package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ScheduleChangeRequestActor implements Enum {

    @JsonProperty("sender")
    SENDER("sender", "0"),

    @JsonProperty("recipient")
    RECIPIENT("recipient", "1"),

    @JsonProperty("manager")
    MANAGER("manager", "2"),

    @JsonProperty("system")
    SYSTEM("system", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private ScheduleChangeRequestActor(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
