package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SafeSearchFilterType implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("strict")
    STRICT("strict", "1"),

    @JsonProperty("moderate")
    MODERATE("moderate", "2");

    private final String name;
    private final String value;

    private SafeSearchFilterType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
