package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RoleAssignmentScopeType implements Enum {

    @JsonProperty("resourceScope")
    RESOURCE_SCOPE("resourceScope", "0"),

    @JsonProperty("allDevices")
    ALL_DEVICES("allDevices", "1"),

    @JsonProperty("allLicensedUsers")
    ALL_LICENSED_USERS("allLicensedUsers", "2"),

    @JsonProperty("allDevicesAndLicensedUsers")
    ALL_DEVICES_AND_LICENSED_USERS("allDevicesAndLicensedUsers", "3");

    private final String name;
    private final String value;

    private RoleAssignmentScopeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
