package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RiskLevel implements Enum {

    @JsonProperty("low")
    LOW("low", "0"),

    @JsonProperty("medium")
    MEDIUM("medium", "1"),

    @JsonProperty("high")
    HIGH("high", "2"),

    @JsonProperty("hidden")
    HIDDEN("hidden", "3"),

    @JsonProperty("none")
    NONE("none", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private RiskLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
