package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ResultantAppState implements Enum {

    @JsonProperty("notApplicable")
    NOT_APPLICABLE("notApplicable", "-1"),

    @JsonProperty("installed")
    INSTALLED("installed", "1"),

    @JsonProperty("failed")
    FAILED("failed", "2"),

    @JsonProperty("notInstalled")
    NOT_INSTALLED("notInstalled", "3"),

    @JsonProperty("uninstallFailed")
    UNINSTALL_FAILED("uninstallFailed", "4"),

    @JsonProperty("pendingInstall")
    PENDING_INSTALL("pendingInstall", "5"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "99");

    private final String name;
    private final String value;

    private ResultantAppState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
