package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RestrictionTrigger implements Enum {

    @JsonProperty("copyPaste")
    COPY_PASTE("copyPaste", "0"),

    @JsonProperty("copyToNetworkShare")
    COPY_TO_NETWORK_SHARE("copyToNetworkShare", "1"),

    @JsonProperty("copyToRemovableMedia")
    COPY_TO_REMOVABLE_MEDIA("copyToRemovableMedia", "2"),

    @JsonProperty("screenCapture")
    SCREEN_CAPTURE("screenCapture", "3"),

    @JsonProperty("print")
    PRINT("print", "4"),

    @JsonProperty("cloudEgress")
    CLOUD_EGRESS("cloudEgress", "5"),

    @JsonProperty("unallowedApps")
    UNALLOWED_APPS("unallowedApps", "6");

    private final String name;
    private final String value;

    private RestrictionTrigger(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
