package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ResponseType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("organizer")
    ORGANIZER("organizer", "1"),

    @JsonProperty("tentativelyAccepted")
    TENTATIVELY_ACCEPTED("tentativelyAccepted", "2"),

    @JsonProperty("accepted")
    ACCEPTED("accepted", "3"),

    @JsonProperty("declined")
    DECLINED("declined", "4"),

    @JsonProperty("notResponded")
    NOT_RESPONDED("notResponded", "5");

    private final String name;
    private final String value;

    private ResponseType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
