package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RequiredPasswordType implements Enum {

    @JsonProperty("deviceDefault")
    DEVICE_DEFAULT("deviceDefault", "0"),

    @JsonProperty("alphanumeric")
    ALPHANUMERIC("alphanumeric", "1"),

    @JsonProperty("numeric")
    NUMERIC("numeric", "2");

    private final String name;
    private final String value;

    private RequiredPasswordType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
