package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RemoteAssistanceState implements Enum {

    @JsonProperty("disabled")
    DISABLED("disabled", "1"),

    @JsonProperty("enabled")
    ENABLED("enabled", "2");

    private final String name;
    private final String value;

    private RemoteAssistanceState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
