package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RemoteAssistanceOnboardingStatus implements Enum {

    @JsonProperty("notOnboarded")
    NOT_ONBOARDED("notOnboarded", "0"),

    @JsonProperty("onboarding")
    ONBOARDING("onboarding", "1"),

    @JsonProperty("onboarded")
    ONBOARDED("onboarded", "2");

    private final String name;
    private final String value;

    private RemoteAssistanceOnboardingStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
