package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RegistryHive implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("currentConfig")
    CURRENT_CONFIG("currentConfig", "1"),

    @JsonProperty("currentUser")
    CURRENT_USER("currentUser", "2"),

    @JsonProperty("localMachineSam")
    LOCAL_MACHINE_SAM("localMachineSam", "3"),

    @JsonProperty("localMachineSecurity")
    LOCAL_MACHINE_SECURITY("localMachineSecurity", "4"),

    @JsonProperty("localMachineSoftware")
    LOCAL_MACHINE_SOFTWARE("localMachineSoftware", "5"),

    @JsonProperty("localMachineSystem")
    LOCAL_MACHINE_SYSTEM("localMachineSystem", "6"),

    @JsonProperty("usersDefault")
    USERS_DEFAULT("usersDefault", "7"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "127");

    private final String name;
    private final String value;

    private RegistryHive(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
