package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RecommendationPriority implements Enum {

    @JsonProperty("low")
    LOW("low", "0"),

    @JsonProperty("medium")
    MEDIUM("medium", "1"),

    @JsonProperty("high")
    HIGH("high", "2");

    private final String name;
    private final String value;

    private RecommendationPriority(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
