package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RecipientScopeType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("internal")
    INTERNAL("internal", "1"),

    @JsonProperty("external")
    EXTERNAL("external", "2"),

    @JsonProperty("externalPartner")
    EXTERNAL_PARTNER("externalPartner", "4"),

    @JsonProperty("externalNonPartner")
    EXTERNAL_NON_PARTNER("externalNonPartner", "8");

    private final String name;
    private final String value;

    private RecipientScopeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
