package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RatingIrelandTelevisionType implements Enum {

    @JsonProperty("allAllowed")
    ALL_ALLOWED("allAllowed", "0"),

    @JsonProperty("allBlocked")
    ALL_BLOCKED("allBlocked", "1"),

    @JsonProperty("general")
    GENERAL("general", "2"),

    @JsonProperty("children")
    CHILDREN("children", "3"),

    @JsonProperty("youngAdults")
    YOUNG_ADULTS("youngAdults", "4"),

    @JsonProperty("parentalSupervision")
    PARENTAL_SUPERVISION("parentalSupervision", "5"),

    @JsonProperty("mature")
    MATURE("mature", "6");

    private final String name;
    private final String value;

    private RatingIrelandTelevisionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
