package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RatingIrelandMoviesType implements Enum {

    @JsonProperty("allAllowed")
    ALL_ALLOWED("allAllowed", "0"),

    @JsonProperty("allBlocked")
    ALL_BLOCKED("allBlocked", "1"),

    @JsonProperty("general")
    GENERAL("general", "2"),

    @JsonProperty("parentalGuidance")
    PARENTAL_GUIDANCE("parentalGuidance", "3"),

    @JsonProperty("agesAbove12")
    AGES_ABOVE12("agesAbove12", "4"),

    @JsonProperty("agesAbove15")
    AGES_ABOVE15("agesAbove15", "5"),

    @JsonProperty("agesAbove16")
    AGES_ABOVE16("agesAbove16", "6"),

    @JsonProperty("adults")
    ADULTS("adults", "7");

    private final String name;
    private final String value;

    private RatingIrelandMoviesType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
