package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum QuarantineReason implements Enum {

    @JsonProperty("EncounteredBaseEscrowThreshold")
    ENCOUNTERED_BASE_ESCROW_THRESHOLD("EncounteredBaseEscrowThreshold", "0"),

    @JsonProperty("EncounteredTotalEscrowThreshold")
    ENCOUNTERED_TOTAL_ESCROW_THRESHOLD("EncounteredTotalEscrowThreshold", "1"),

    @JsonProperty("EncounteredEscrowProportionThreshold")
    ENCOUNTERED_ESCROW_PROPORTION_THRESHOLD("EncounteredEscrowProportionThreshold", "2"),

    @JsonProperty("EncounteredQuarantineException")
    ENCOUNTERED_QUARANTINE_EXCEPTION("EncounteredQuarantineException", "4"),

    @JsonProperty("Unknown")
    UNKNOWN("Unknown", "8"),

    @JsonProperty("QuarantinedOnDemand")
    QUARANTINED_ON_DEMAND("QuarantinedOnDemand", "16"),

    @JsonProperty("TooManyDeletes")
    TOO_MANY_DELETES("TooManyDeletes", "32"),

    @JsonProperty("IngestionInterrupted")
    INGESTION_INTERRUPTED("IngestionInterrupted", "64");

    private final String name;
    private final String value;

    private QuarantineReason(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
