package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ProvisioningStepType implements Enum {

    @JsonProperty("import")
    IMPORT("import", "0"),

    @JsonProperty("scoping")
    SCOPING("scoping", "1"),

    @JsonProperty("matching")
    MATCHING("matching", "2"),

    @JsonProperty("processing")
    PROCESSING("processing", "3"),

    @JsonProperty("referenceResolution")
    REFERENCE_RESOLUTION("referenceResolution", "4"),

    @JsonProperty("export")
    EXPORT("export", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private ProvisioningStepType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
