package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum Priority implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("High")
    HIGH("High", "1"),

    @JsonProperty("Low")
    LOW("Low", "2");

    private final String name;
    private final String value;

    private Priority(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
