package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PrinterProcessingStateReason implements Enum {

    @JsonProperty("paused")
    PAUSED("paused", "0"),

    @JsonProperty("mediaJam")
    MEDIA_JAM("mediaJam", "2"),

    @JsonProperty("mediaNeeded")
    MEDIA_NEEDED("mediaNeeded", "3"),

    @JsonProperty("mediaLow")
    MEDIA_LOW("mediaLow", "4"),

    @JsonProperty("mediaEmpty")
    MEDIA_EMPTY("mediaEmpty", "5"),

    @JsonProperty("coverOpen")
    COVER_OPEN("coverOpen", "6"),

    @JsonProperty("interlockOpen")
    INTERLOCK_OPEN("interlockOpen", "7"),

    @JsonProperty("outputTrayMissing")
    OUTPUT_TRAY_MISSING("outputTrayMissing", "9"),

    @JsonProperty("outputAreaFull")
    OUTPUT_AREA_FULL("outputAreaFull", "10"),

    @JsonProperty("markerSupplyLow")
    MARKER_SUPPLY_LOW("markerSupplyLow", "11"),

    @JsonProperty("markerSupplyEmpty")
    MARKER_SUPPLY_EMPTY("markerSupplyEmpty", "12"),

    @JsonProperty("inputTrayMissing")
    INPUT_TRAY_MISSING("inputTrayMissing", "13"),

    @JsonProperty("outputAreaAlmostFull")
    OUTPUT_AREA_ALMOST_FULL("outputAreaAlmostFull", "14"),

    @JsonProperty("markerWasteAlmostFull")
    MARKER_WASTE_ALMOST_FULL("markerWasteAlmostFull", "15"),

    @JsonProperty("markerWasteFull")
    MARKER_WASTE_FULL("markerWasteFull", "16"),

    @JsonProperty("fuserOverTemp")
    FUSER_OVER_TEMP("fuserOverTemp", "17"),

    @JsonProperty("fuserUnderTemp")
    FUSER_UNDER_TEMP("fuserUnderTemp", "18"),

    @JsonProperty("other")
    OTHER("other", "19"),

    @JsonProperty("none")
    NONE("none", "20"),

    @JsonProperty("movingToPaused")
    MOVING_TO_PAUSED("movingToPaused", "21"),

    @JsonProperty("shutdown")
    SHUTDOWN("shutdown", "22"),

    @JsonProperty("connectingToDevice")
    CONNECTING_TO_DEVICE("connectingToDevice", "23"),

    @JsonProperty("timedOut")
    TIMED_OUT("timedOut", "24"),

    @JsonProperty("stopping")
    STOPPING("stopping", "25"),

    @JsonProperty("stoppedPartially")
    STOPPED_PARTIALLY("stoppedPartially", "26"),

    @JsonProperty("tonerLow")
    TONER_LOW("tonerLow", "27"),

    @JsonProperty("tonerEmpty")
    TONER_EMPTY("tonerEmpty", "28"),

    @JsonProperty("spoolAreaFull")
    SPOOL_AREA_FULL("spoolAreaFull", "29"),

    @JsonProperty("doorOpen")
    DOOR_OPEN("doorOpen", "30"),

    @JsonProperty("opticalPhotoConductorNearEndOfLife")
    OPTICAL_PHOTO_CONDUCTOR_NEAR_END_OF_LIFE("opticalPhotoConductorNearEndOfLife", "31"),

    @JsonProperty("opticalPhotoConductorLifeOver")
    OPTICAL_PHOTO_CONDUCTOR_LIFE_OVER("opticalPhotoConductorLifeOver", "32"),

    @JsonProperty("developerLow")
    DEVELOPER_LOW("developerLow", "33"),

    @JsonProperty("developerEmpty")
    DEVELOPER_EMPTY("developerEmpty", "34"),

    @JsonProperty("interpreterResourceUnavailable")
    INTERPRETER_RESOURCE_UNAVAILABLE("interpreterResourceUnavailable", "35"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "36");

    private final String name;
    private final String value;

    private PrinterProcessingStateReason(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
