package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PrinterProcessingStateDetail implements Enum {

    @JsonProperty("paused")
    PAUSED("paused", "0"),

    @JsonProperty("mediaJam")
    MEDIA_JAM("mediaJam", "2"),

    @JsonProperty("mediaNeeded")
    MEDIA_NEEDED("mediaNeeded", "3"),

    @JsonProperty("mediaLow")
    MEDIA_LOW("mediaLow", "4"),

    @JsonProperty("mediaEmpty")
    MEDIA_EMPTY("mediaEmpty", "5"),

    @JsonProperty("coverOpen")
    COVER_OPEN("coverOpen", "6"),

    @JsonProperty("interlockOpen")
    INTERLOCK_OPEN("interlockOpen", "7"),

    @JsonProperty("outputTrayMissing")
    OUTPUT_TRAY_MISSING("outputTrayMissing", "9"),

    @JsonProperty("outputAreaFull")
    OUTPUT_AREA_FULL("outputAreaFull", "10"),

    @JsonProperty("markerSupplyLow")
    MARKER_SUPPLY_LOW("markerSupplyLow", "11"),

    @JsonProperty("markerSupplyEmpty")
    MARKER_SUPPLY_EMPTY("markerSupplyEmpty", "12"),

    @JsonProperty("inputTrayMissing")
    INPUT_TRAY_MISSING("inputTrayMissing", "13"),

    @JsonProperty("outputAreaAlmostFull")
    OUTPUT_AREA_ALMOST_FULL("outputAreaAlmostFull", "14"),

    @JsonProperty("markerWasteAlmostFull")
    MARKER_WASTE_ALMOST_FULL("markerWasteAlmostFull", "15"),

    @JsonProperty("markerWasteFull")
    MARKER_WASTE_FULL("markerWasteFull", "16"),

    @JsonProperty("fuserOverTemp")
    FUSER_OVER_TEMP("fuserOverTemp", "17"),

    @JsonProperty("fuserUnderTemp")
    FUSER_UNDER_TEMP("fuserUnderTemp", "18"),

    @JsonProperty("other")
    OTHER("other", "19"),

    @JsonProperty("none")
    NONE("none", "20"),

    @JsonProperty("movingToPaused")
    MOVING_TO_PAUSED("movingToPaused", "21"),

    @JsonProperty("shutdown")
    SHUTDOWN("shutdown", "22"),

    @JsonProperty("connectingToDevice")
    CONNECTING_TO_DEVICE("connectingToDevice", "23"),

    @JsonProperty("timedOut")
    TIMED_OUT("timedOut", "24"),

    @JsonProperty("stopping")
    STOPPING("stopping", "25"),

    @JsonProperty("stoppedPartially")
    STOPPED_PARTIALLY("stoppedPartially", "26"),

    @JsonProperty("tonerLow")
    TONER_LOW("tonerLow", "27"),

    @JsonProperty("tonerEmpty")
    TONER_EMPTY("tonerEmpty", "28"),

    @JsonProperty("spoolAreaFull")
    SPOOL_AREA_FULL("spoolAreaFull", "29"),

    @JsonProperty("doorOpen")
    DOOR_OPEN("doorOpen", "30"),

    @JsonProperty("opticalPhotoConductorNearEndOfLife")
    OPTICAL_PHOTO_CONDUCTOR_NEAR_END_OF_LIFE("opticalPhotoConductorNearEndOfLife", "31"),

    @JsonProperty("opticalPhotoConductorLifeOver")
    OPTICAL_PHOTO_CONDUCTOR_LIFE_OVER("opticalPhotoConductorLifeOver", "32"),

    @JsonProperty("developerLow")
    DEVELOPER_LOW("developerLow", "33"),

    @JsonProperty("developerEmpty")
    DEVELOPER_EMPTY("developerEmpty", "34"),

    @JsonProperty("interpreterResourceUnavailable")
    INTERPRETER_RESOURCE_UNAVAILABLE("interpreterResourceUnavailable", "35"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "36"),

    @JsonProperty("alertRemovalOfBinaryChangeEntry")
    ALERT_REMOVAL_OF_BINARY_CHANGE_ENTRY("alertRemovalOfBinaryChangeEntry", "37"),

    @JsonProperty("banderAdded")
    BANDER_ADDED("banderAdded", "38"),

    @JsonProperty("banderAlmostEmpty")
    BANDER_ALMOST_EMPTY("banderAlmostEmpty", "39"),

    @JsonProperty("banderAlmostFull")
    BANDER_ALMOST_FULL("banderAlmostFull", "40"),

    @JsonProperty("banderAtLimit")
    BANDER_AT_LIMIT("banderAtLimit", "41"),

    @JsonProperty("banderClosed")
    BANDER_CLOSED("banderClosed", "42"),

    @JsonProperty("banderConfigurationChange")
    BANDER_CONFIGURATION_CHANGE("banderConfigurationChange", "43"),

    @JsonProperty("banderCoverClosed")
    BANDER_COVER_CLOSED("banderCoverClosed", "44"),

    @JsonProperty("banderCoverOpen")
    BANDER_COVER_OPEN("banderCoverOpen", "45"),

    @JsonProperty("banderEmpty")
    BANDER_EMPTY("banderEmpty", "46"),

    @JsonProperty("banderFull")
    BANDER_FULL("banderFull", "47"),

    @JsonProperty("banderInterlockClosed")
    BANDER_INTERLOCK_CLOSED("banderInterlockClosed", "48"),

    @JsonProperty("banderInterlockOpen")
    BANDER_INTERLOCK_OPEN("banderInterlockOpen", "49"),

    @JsonProperty("banderJam")
    BANDER_JAM("banderJam", "50"),

    @JsonProperty("banderLifeAlmostOver")
    BANDER_LIFE_ALMOST_OVER("banderLifeAlmostOver", "51"),

    @JsonProperty("banderLifeOver")
    BANDER_LIFE_OVER("banderLifeOver", "52"),

    @JsonProperty("banderMemoryExhausted")
    BANDER_MEMORY_EXHAUSTED("banderMemoryExhausted", "53"),

    @JsonProperty("banderMissing")
    BANDER_MISSING("banderMissing", "54"),

    @JsonProperty("banderMotorFailure")
    BANDER_MOTOR_FAILURE("banderMotorFailure", "55"),

    @JsonProperty("banderNearLimit")
    BANDER_NEAR_LIMIT("banderNearLimit", "56"),

    @JsonProperty("banderOffline")
    BANDER_OFFLINE("banderOffline", "57"),

    @JsonProperty("banderOpened")
    BANDER_OPENED("banderOpened", "58"),

    @JsonProperty("banderOverTemperature")
    BANDER_OVER_TEMPERATURE("banderOverTemperature", "59"),

    @JsonProperty("banderPowerSaver")
    BANDER_POWER_SAVER("banderPowerSaver", "60"),

    @JsonProperty("banderRecoverableFailure")
    BANDER_RECOVERABLE_FAILURE("banderRecoverableFailure", "61"),

    @JsonProperty("banderRecoverableStorage")
    BANDER_RECOVERABLE_STORAGE("banderRecoverableStorage", "62"),

    @JsonProperty("banderRemoved")
    BANDER_REMOVED("banderRemoved", "63"),

    @JsonProperty("banderResourceAdded")
    BANDER_RESOURCE_ADDED("banderResourceAdded", "64"),

    @JsonProperty("banderResourceRemoved")
    BANDER_RESOURCE_REMOVED("banderResourceRemoved", "65"),

    @JsonProperty("banderThermistorFailure")
    BANDER_THERMISTOR_FAILURE("banderThermistorFailure", "66"),

    @JsonProperty("banderTimingFailure")
    BANDER_TIMING_FAILURE("banderTimingFailure", "67"),

    @JsonProperty("banderTurnedOff")
    BANDER_TURNED_OFF("banderTurnedOff", "68"),

    @JsonProperty("banderTurnedOn")
    BANDER_TURNED_ON("banderTurnedOn", "69"),

    @JsonProperty("banderUnderTemperature")
    BANDER_UNDER_TEMPERATURE("banderUnderTemperature", "70"),

    @JsonProperty("banderUnrecoverableFailure")
    BANDER_UNRECOVERABLE_FAILURE("banderUnrecoverableFailure", "71"),

    @JsonProperty("banderUnrecoverableStorageError")
    BANDER_UNRECOVERABLE_STORAGE_ERROR("banderUnrecoverableStorageError", "72"),

    @JsonProperty("banderWarmingUp")
    BANDER_WARMING_UP("banderWarmingUp", "73"),

    @JsonProperty("binderAdded")
    BINDER_ADDED("binderAdded", "74"),

    @JsonProperty("binderAlmostEmpty")
    BINDER_ALMOST_EMPTY("binderAlmostEmpty", "75"),

    @JsonProperty("binderAlmostFull")
    BINDER_ALMOST_FULL("binderAlmostFull", "76"),

    @JsonProperty("binderAtLimit")
    BINDER_AT_LIMIT("binderAtLimit", "77"),

    @JsonProperty("binderClosed")
    BINDER_CLOSED("binderClosed", "78"),

    @JsonProperty("binderConfigurationChange")
    BINDER_CONFIGURATION_CHANGE("binderConfigurationChange", "79"),

    @JsonProperty("binderCoverClosed")
    BINDER_COVER_CLOSED("binderCoverClosed", "80"),

    @JsonProperty("binderCoverOpen")
    BINDER_COVER_OPEN("binderCoverOpen", "81"),

    @JsonProperty("binderEmpty")
    BINDER_EMPTY("binderEmpty", "82"),

    @JsonProperty("binderFull")
    BINDER_FULL("binderFull", "83"),

    @JsonProperty("binderInterlockClosed")
    BINDER_INTERLOCK_CLOSED("binderInterlockClosed", "84"),

    @JsonProperty("binderInterlockOpen")
    BINDER_INTERLOCK_OPEN("binderInterlockOpen", "85"),

    @JsonProperty("binderJam")
    BINDER_JAM("binderJam", "86"),

    @JsonProperty("binderLifeAlmostOver")
    BINDER_LIFE_ALMOST_OVER("binderLifeAlmostOver", "87"),

    @JsonProperty("binderLifeOver")
    BINDER_LIFE_OVER("binderLifeOver", "88"),

    @JsonProperty("binderMemoryExhausted")
    BINDER_MEMORY_EXHAUSTED("binderMemoryExhausted", "89"),

    @JsonProperty("binderMissing")
    BINDER_MISSING("binderMissing", "90"),

    @JsonProperty("binderMotorFailure")
    BINDER_MOTOR_FAILURE("binderMotorFailure", "91"),

    @JsonProperty("binderNearLimit")
    BINDER_NEAR_LIMIT("binderNearLimit", "92"),

    @JsonProperty("binderOffline")
    BINDER_OFFLINE("binderOffline", "93"),

    @JsonProperty("binderOpened")
    BINDER_OPENED("binderOpened", "94"),

    @JsonProperty("binderOverTemperature")
    BINDER_OVER_TEMPERATURE("binderOverTemperature", "95"),

    @JsonProperty("binderPowerSaver")
    BINDER_POWER_SAVER("binderPowerSaver", "96"),

    @JsonProperty("binderRecoverableFailure")
    BINDER_RECOVERABLE_FAILURE("binderRecoverableFailure", "97"),

    @JsonProperty("binderRecoverableStorage")
    BINDER_RECOVERABLE_STORAGE("binderRecoverableStorage", "98"),

    @JsonProperty("binderRemoved")
    BINDER_REMOVED("binderRemoved", "99"),

    @JsonProperty("binderResourceAdded")
    BINDER_RESOURCE_ADDED("binderResourceAdded", "100"),

    @JsonProperty("binderResourceRemoved")
    BINDER_RESOURCE_REMOVED("binderResourceRemoved", "101"),

    @JsonProperty("binderThermistorFailure")
    BINDER_THERMISTOR_FAILURE("binderThermistorFailure", "102"),

    @JsonProperty("binderTimingFailure")
    BINDER_TIMING_FAILURE("binderTimingFailure", "103"),

    @JsonProperty("binderTurnedOff")
    BINDER_TURNED_OFF("binderTurnedOff", "104"),

    @JsonProperty("binderTurnedOn")
    BINDER_TURNED_ON("binderTurnedOn", "105"),

    @JsonProperty("binderUnderTemperature")
    BINDER_UNDER_TEMPERATURE("binderUnderTemperature", "106"),

    @JsonProperty("binderUnrecoverableFailure")
    BINDER_UNRECOVERABLE_FAILURE("binderUnrecoverableFailure", "107"),

    @JsonProperty("binderUnrecoverableStorageError")
    BINDER_UNRECOVERABLE_STORAGE_ERROR("binderUnrecoverableStorageError", "108"),

    @JsonProperty("binderWarmingUp")
    BINDER_WARMING_UP("binderWarmingUp", "109"),

    @JsonProperty("cameraFailure")
    CAMERA_FAILURE("cameraFailure", "110"),

    @JsonProperty("chamberCooling")
    CHAMBER_COOLING("chamberCooling", "111"),

    @JsonProperty("chamberFailure")
    CHAMBER_FAILURE("chamberFailure", "112"),

    @JsonProperty("chamberHeating")
    CHAMBER_HEATING("chamberHeating", "113"),

    @JsonProperty("chamberTemperatureHigh")
    CHAMBER_TEMPERATURE_HIGH("chamberTemperatureHigh", "114"),

    @JsonProperty("chamberTemperatureLow")
    CHAMBER_TEMPERATURE_LOW("chamberTemperatureLow", "115"),

    @JsonProperty("cleanerLifeAlmostOver")
    CLEANER_LIFE_ALMOST_OVER("cleanerLifeAlmostOver", "116"),

    @JsonProperty("cleanerLifeOver")
    CLEANER_LIFE_OVER("cleanerLifeOver", "117"),

    @JsonProperty("configurationChange")
    CONFIGURATION_CHANGE("configurationChange", "118"),

    @JsonProperty("deactivated")
    DEACTIVATED("deactivated", "119"),

    @JsonProperty("deleted")
    DELETED("deleted", "120"),

    @JsonProperty("dieCutterAdded")
    DIE_CUTTER_ADDED("dieCutterAdded", "121"),

    @JsonProperty("dieCutterAlmostEmpty")
    DIE_CUTTER_ALMOST_EMPTY("dieCutterAlmostEmpty", "122"),

    @JsonProperty("dieCutterAlmostFull")
    DIE_CUTTER_ALMOST_FULL("dieCutterAlmostFull", "123"),

    @JsonProperty("dieCutterAtLimit")
    DIE_CUTTER_AT_LIMIT("dieCutterAtLimit", "124"),

    @JsonProperty("dieCutterClosed")
    DIE_CUTTER_CLOSED("dieCutterClosed", "125"),

    @JsonProperty("dieCutterConfigurationChange")
    DIE_CUTTER_CONFIGURATION_CHANGE("dieCutterConfigurationChange", "126"),

    @JsonProperty("dieCutterCoverClosed")
    DIE_CUTTER_COVER_CLOSED("dieCutterCoverClosed", "127"),

    @JsonProperty("dieCutterCoverOpen")
    DIE_CUTTER_COVER_OPEN("dieCutterCoverOpen", "128"),

    @JsonProperty("dieCutterEmpty")
    DIE_CUTTER_EMPTY("dieCutterEmpty", "129"),

    @JsonProperty("dieCutterFull")
    DIE_CUTTER_FULL("dieCutterFull", "130"),

    @JsonProperty("dieCutterInterlockClosed")
    DIE_CUTTER_INTERLOCK_CLOSED("dieCutterInterlockClosed", "131"),

    @JsonProperty("dieCutterInterlockOpen")
    DIE_CUTTER_INTERLOCK_OPEN("dieCutterInterlockOpen", "132"),

    @JsonProperty("dieCutterJam")
    DIE_CUTTER_JAM("dieCutterJam", "133"),

    @JsonProperty("dieCutterLifeAlmostOver")
    DIE_CUTTER_LIFE_ALMOST_OVER("dieCutterLifeAlmostOver", "134"),

    @JsonProperty("dieCutterLifeOver")
    DIE_CUTTER_LIFE_OVER("dieCutterLifeOver", "135"),

    @JsonProperty("dieCutterMemoryExhausted")
    DIE_CUTTER_MEMORY_EXHAUSTED("dieCutterMemoryExhausted", "136"),

    @JsonProperty("dieCutterMissing")
    DIE_CUTTER_MISSING("dieCutterMissing", "137"),

    @JsonProperty("dieCutterMotorFailure")
    DIE_CUTTER_MOTOR_FAILURE("dieCutterMotorFailure", "138"),

    @JsonProperty("dieCutterNearLimit")
    DIE_CUTTER_NEAR_LIMIT("dieCutterNearLimit", "139"),

    @JsonProperty("dieCutterOffline")
    DIE_CUTTER_OFFLINE("dieCutterOffline", "140"),

    @JsonProperty("dieCutterOpened")
    DIE_CUTTER_OPENED("dieCutterOpened", "141"),

    @JsonProperty("dieCutterOverTemperature")
    DIE_CUTTER_OVER_TEMPERATURE("dieCutterOverTemperature", "142"),

    @JsonProperty("dieCutterPowerSaver")
    DIE_CUTTER_POWER_SAVER("dieCutterPowerSaver", "143"),

    @JsonProperty("dieCutterRecoverableFailure")
    DIE_CUTTER_RECOVERABLE_FAILURE("dieCutterRecoverableFailure", "144"),

    @JsonProperty("dieCutterRecoverableStorage")
    DIE_CUTTER_RECOVERABLE_STORAGE("dieCutterRecoverableStorage", "145"),

    @JsonProperty("dieCutterRemoved")
    DIE_CUTTER_REMOVED("dieCutterRemoved", "146"),

    @JsonProperty("dieCutterResourceAdded")
    DIE_CUTTER_RESOURCE_ADDED("dieCutterResourceAdded", "147"),

    @JsonProperty("dieCutterResourceRemoved")
    DIE_CUTTER_RESOURCE_REMOVED("dieCutterResourceRemoved", "148"),

    @JsonProperty("dieCutterThermistorFailure")
    DIE_CUTTER_THERMISTOR_FAILURE("dieCutterThermistorFailure", "149"),

    @JsonProperty("dieCutterTimingFailure")
    DIE_CUTTER_TIMING_FAILURE("dieCutterTimingFailure", "150"),

    @JsonProperty("dieCutterTurnedOff")
    DIE_CUTTER_TURNED_OFF("dieCutterTurnedOff", "151"),

    @JsonProperty("dieCutterTurnedOn")
    DIE_CUTTER_TURNED_ON("dieCutterTurnedOn", "152"),

    @JsonProperty("dieCutterUnderTemperature")
    DIE_CUTTER_UNDER_TEMPERATURE("dieCutterUnderTemperature", "153"),

    @JsonProperty("dieCutterUnrecoverableFailure")
    DIE_CUTTER_UNRECOVERABLE_FAILURE("dieCutterUnrecoverableFailure", "154"),

    @JsonProperty("dieCutterUnrecoverableStorageError")
    DIE_CUTTER_UNRECOVERABLE_STORAGE_ERROR("dieCutterUnrecoverableStorageError", "155"),

    @JsonProperty("dieCutterWarmingUp")
    DIE_CUTTER_WARMING_UP("dieCutterWarmingUp", "156"),

    @JsonProperty("extruderCooling")
    EXTRUDER_COOLING("extruderCooling", "157"),

    @JsonProperty("extruderFailure")
    EXTRUDER_FAILURE("extruderFailure", "158"),

    @JsonProperty("extruderHeating")
    EXTRUDER_HEATING("extruderHeating", "159"),

    @JsonProperty("extruderJam")
    EXTRUDER_JAM("extruderJam", "160"),

    @JsonProperty("extruderTemperatureHigh")
    EXTRUDER_TEMPERATURE_HIGH("extruderTemperatureHigh", "161"),

    @JsonProperty("extruderTemperatureLow")
    EXTRUDER_TEMPERATURE_LOW("extruderTemperatureLow", "162"),

    @JsonProperty("fanFailure")
    FAN_FAILURE("fanFailure", "163"),

    @JsonProperty("faxModemLifeAlmostOver")
    FAX_MODEM_LIFE_ALMOST_OVER("faxModemLifeAlmostOver", "164"),

    @JsonProperty("faxModemLifeOver")
    FAX_MODEM_LIFE_OVER("faxModemLifeOver", "165"),

    @JsonProperty("faxModemMissing")
    FAX_MODEM_MISSING("faxModemMissing", "166"),

    @JsonProperty("faxModemTurnedOff")
    FAX_MODEM_TURNED_OFF("faxModemTurnedOff", "167"),

    @JsonProperty("faxModemTurnedOn")
    FAX_MODEM_TURNED_ON("faxModemTurnedOn", "168"),

    @JsonProperty("folderAdded")
    FOLDER_ADDED("folderAdded", "169"),

    @JsonProperty("folderAlmostEmpty")
    FOLDER_ALMOST_EMPTY("folderAlmostEmpty", "170"),

    @JsonProperty("folderAlmostFull")
    FOLDER_ALMOST_FULL("folderAlmostFull", "171"),

    @JsonProperty("folderAtLimit")
    FOLDER_AT_LIMIT("folderAtLimit", "172"),

    @JsonProperty("folderClosed")
    FOLDER_CLOSED("folderClosed", "173"),

    @JsonProperty("folderConfigurationChange")
    FOLDER_CONFIGURATION_CHANGE("folderConfigurationChange", "174"),

    @JsonProperty("folderCoverClosed")
    FOLDER_COVER_CLOSED("folderCoverClosed", "175"),

    @JsonProperty("folderCoverOpen")
    FOLDER_COVER_OPEN("folderCoverOpen", "176"),

    @JsonProperty("folderEmpty")
    FOLDER_EMPTY("folderEmpty", "177"),

    @JsonProperty("folderFull")
    FOLDER_FULL("folderFull", "178"),

    @JsonProperty("folderInterlockClosed")
    FOLDER_INTERLOCK_CLOSED("folderInterlockClosed", "179"),

    @JsonProperty("folderInterlockOpen")
    FOLDER_INTERLOCK_OPEN("folderInterlockOpen", "180"),

    @JsonProperty("folderJam")
    FOLDER_JAM("folderJam", "181"),

    @JsonProperty("folderLifeAlmostOver")
    FOLDER_LIFE_ALMOST_OVER("folderLifeAlmostOver", "182"),

    @JsonProperty("folderLifeOver")
    FOLDER_LIFE_OVER("folderLifeOver", "183"),

    @JsonProperty("folderMemoryExhausted")
    FOLDER_MEMORY_EXHAUSTED("folderMemoryExhausted", "184"),

    @JsonProperty("folderMissing")
    FOLDER_MISSING("folderMissing", "185"),

    @JsonProperty("folderMotorFailure")
    FOLDER_MOTOR_FAILURE("folderMotorFailure", "186"),

    @JsonProperty("folderNearLimit")
    FOLDER_NEAR_LIMIT("folderNearLimit", "187"),

    @JsonProperty("folderOffline")
    FOLDER_OFFLINE("folderOffline", "188"),

    @JsonProperty("folderOpened")
    FOLDER_OPENED("folderOpened", "189"),

    @JsonProperty("folderOverTemperature")
    FOLDER_OVER_TEMPERATURE("folderOverTemperature", "190"),

    @JsonProperty("folderPowerSaver")
    FOLDER_POWER_SAVER("folderPowerSaver", "191"),

    @JsonProperty("folderRecoverableFailure")
    FOLDER_RECOVERABLE_FAILURE("folderRecoverableFailure", "192"),

    @JsonProperty("folderRecoverableStorage")
    FOLDER_RECOVERABLE_STORAGE("folderRecoverableStorage", "193"),

    @JsonProperty("folderRemoved")
    FOLDER_REMOVED("folderRemoved", "194"),

    @JsonProperty("folderResourceAdded")
    FOLDER_RESOURCE_ADDED("folderResourceAdded", "195"),

    @JsonProperty("folderResourceRemoved")
    FOLDER_RESOURCE_REMOVED("folderResourceRemoved", "196"),

    @JsonProperty("folderThermistorFailure")
    FOLDER_THERMISTOR_FAILURE("folderThermistorFailure", "197"),

    @JsonProperty("folderTimingFailure")
    FOLDER_TIMING_FAILURE("folderTimingFailure", "198"),

    @JsonProperty("folderTurnedOff")
    FOLDER_TURNED_OFF("folderTurnedOff", "199"),

    @JsonProperty("folderTurnedOn")
    FOLDER_TURNED_ON("folderTurnedOn", "200"),

    @JsonProperty("folderUnderTemperature")
    FOLDER_UNDER_TEMPERATURE("folderUnderTemperature", "201"),

    @JsonProperty("folderUnrecoverableFailure")
    FOLDER_UNRECOVERABLE_FAILURE("folderUnrecoverableFailure", "202"),

    @JsonProperty("folderUnrecoverableStorageError")
    FOLDER_UNRECOVERABLE_STORAGE_ERROR("folderUnrecoverableStorageError", "203"),

    @JsonProperty("folderWarmingUp")
    FOLDER_WARMING_UP("folderWarmingUp", "204"),

    @JsonProperty("hibernate")
    HIBERNATE("hibernate", "205"),

    @JsonProperty("holdNewJobs")
    HOLD_NEW_JOBS("holdNewJobs", "206"),

    @JsonProperty("identifyPrinterRequested")
    IDENTIFY_PRINTER_REQUESTED("identifyPrinterRequested", "207"),

    @JsonProperty("imprinterAdded")
    IMPRINTER_ADDED("imprinterAdded", "208"),

    @JsonProperty("imprinterAlmostEmpty")
    IMPRINTER_ALMOST_EMPTY("imprinterAlmostEmpty", "209"),

    @JsonProperty("imprinterAlmostFull")
    IMPRINTER_ALMOST_FULL("imprinterAlmostFull", "210"),

    @JsonProperty("imprinterAtLimit")
    IMPRINTER_AT_LIMIT("imprinterAtLimit", "211"),

    @JsonProperty("imprinterClosed")
    IMPRINTER_CLOSED("imprinterClosed", "212"),

    @JsonProperty("imprinterConfigurationChange")
    IMPRINTER_CONFIGURATION_CHANGE("imprinterConfigurationChange", "213"),

    @JsonProperty("imprinterCoverClosed")
    IMPRINTER_COVER_CLOSED("imprinterCoverClosed", "214"),

    @JsonProperty("imprinterCoverOpen")
    IMPRINTER_COVER_OPEN("imprinterCoverOpen", "215"),

    @JsonProperty("imprinterEmpty")
    IMPRINTER_EMPTY("imprinterEmpty", "216"),

    @JsonProperty("imprinterFull")
    IMPRINTER_FULL("imprinterFull", "217"),

    @JsonProperty("imprinterInterlockClosed")
    IMPRINTER_INTERLOCK_CLOSED("imprinterInterlockClosed", "218"),

    @JsonProperty("imprinterInterlockOpen")
    IMPRINTER_INTERLOCK_OPEN("imprinterInterlockOpen", "219"),

    @JsonProperty("imprinterJam")
    IMPRINTER_JAM("imprinterJam", "220"),

    @JsonProperty("imprinterLifeAlmostOver")
    IMPRINTER_LIFE_ALMOST_OVER("imprinterLifeAlmostOver", "221"),

    @JsonProperty("imprinterLifeOver")
    IMPRINTER_LIFE_OVER("imprinterLifeOver", "222"),

    @JsonProperty("imprinterMemoryExhausted")
    IMPRINTER_MEMORY_EXHAUSTED("imprinterMemoryExhausted", "223"),

    @JsonProperty("imprinterMissing")
    IMPRINTER_MISSING("imprinterMissing", "224"),

    @JsonProperty("imprinterMotorFailure")
    IMPRINTER_MOTOR_FAILURE("imprinterMotorFailure", "225"),

    @JsonProperty("imprinterNearLimit")
    IMPRINTER_NEAR_LIMIT("imprinterNearLimit", "226"),

    @JsonProperty("imprinterOffline")
    IMPRINTER_OFFLINE("imprinterOffline", "227"),

    @JsonProperty("imprinterOpened")
    IMPRINTER_OPENED("imprinterOpened", "228"),

    @JsonProperty("imprinterOverTemperature")
    IMPRINTER_OVER_TEMPERATURE("imprinterOverTemperature", "229"),

    @JsonProperty("imprinterPowerSaver")
    IMPRINTER_POWER_SAVER("imprinterPowerSaver", "230"),

    @JsonProperty("imprinterRecoverableFailure")
    IMPRINTER_RECOVERABLE_FAILURE("imprinterRecoverableFailure", "231"),

    @JsonProperty("imprinterRecoverableStorage")
    IMPRINTER_RECOVERABLE_STORAGE("imprinterRecoverableStorage", "232"),

    @JsonProperty("imprinterRemoved")
    IMPRINTER_REMOVED("imprinterRemoved", "233"),

    @JsonProperty("imprinterResourceAdded")
    IMPRINTER_RESOURCE_ADDED("imprinterResourceAdded", "234"),

    @JsonProperty("imprinterResourceRemoved")
    IMPRINTER_RESOURCE_REMOVED("imprinterResourceRemoved", "235"),

    @JsonProperty("imprinterThermistorFailure")
    IMPRINTER_THERMISTOR_FAILURE("imprinterThermistorFailure", "236"),

    @JsonProperty("imprinterTimingFailure")
    IMPRINTER_TIMING_FAILURE("imprinterTimingFailure", "237"),

    @JsonProperty("imprinterTurnedOff")
    IMPRINTER_TURNED_OFF("imprinterTurnedOff", "238"),

    @JsonProperty("imprinterTurnedOn")
    IMPRINTER_TURNED_ON("imprinterTurnedOn", "239"),

    @JsonProperty("imprinterUnderTemperature")
    IMPRINTER_UNDER_TEMPERATURE("imprinterUnderTemperature", "240"),

    @JsonProperty("imprinterUnrecoverableFailure")
    IMPRINTER_UNRECOVERABLE_FAILURE("imprinterUnrecoverableFailure", "241"),

    @JsonProperty("imprinterUnrecoverableStorageError")
    IMPRINTER_UNRECOVERABLE_STORAGE_ERROR("imprinterUnrecoverableStorageError", "242"),

    @JsonProperty("imprinterWarmingUp")
    IMPRINTER_WARMING_UP("imprinterWarmingUp", "243"),

    @JsonProperty("inputCannotFeedSizeSelected")
    INPUT_CANNOT_FEED_SIZE_SELECTED("inputCannotFeedSizeSelected", "244"),

    @JsonProperty("inputManualInputRequest")
    INPUT_MANUAL_INPUT_REQUEST("inputManualInputRequest", "245"),

    @JsonProperty("inputMediaColorChange")
    INPUT_MEDIA_COLOR_CHANGE("inputMediaColorChange", "246"),

    @JsonProperty("inputMediaFormPartsChange")
    INPUT_MEDIA_FORM_PARTS_CHANGE("inputMediaFormPartsChange", "247"),

    @JsonProperty("inputMediaSizeChange")
    INPUT_MEDIA_SIZE_CHANGE("inputMediaSizeChange", "248"),

    @JsonProperty("inputMediaTrayFailure")
    INPUT_MEDIA_TRAY_FAILURE("inputMediaTrayFailure", "249"),

    @JsonProperty("inputMediaTrayFeedError")
    INPUT_MEDIA_TRAY_FEED_ERROR("inputMediaTrayFeedError", "250"),

    @JsonProperty("inputMediaTrayJam")
    INPUT_MEDIA_TRAY_JAM("inputMediaTrayJam", "251"),

    @JsonProperty("inputMediaTypeChange")
    INPUT_MEDIA_TYPE_CHANGE("inputMediaTypeChange", "252"),

    @JsonProperty("inputMediaWeightChange")
    INPUT_MEDIA_WEIGHT_CHANGE("inputMediaWeightChange", "253"),

    @JsonProperty("inputPickRollerFailure")
    INPUT_PICK_ROLLER_FAILURE("inputPickRollerFailure", "254"),

    @JsonProperty("inputPickRollerLifeOver")
    INPUT_PICK_ROLLER_LIFE_OVER("inputPickRollerLifeOver", "255"),

    @JsonProperty("inputPickRollerLifeWarn")
    INPUT_PICK_ROLLER_LIFE_WARN("inputPickRollerLifeWarn", "256"),

    @JsonProperty("inputPickRollerMissing")
    INPUT_PICK_ROLLER_MISSING("inputPickRollerMissing", "257"),

    @JsonProperty("inputTrayElevationFailure")
    INPUT_TRAY_ELEVATION_FAILURE("inputTrayElevationFailure", "258"),

    @JsonProperty("inputTrayPositionFailure")
    INPUT_TRAY_POSITION_FAILURE("inputTrayPositionFailure", "259"),

    @JsonProperty("inserterAdded")
    INSERTER_ADDED("inserterAdded", "260"),

    @JsonProperty("inserterAlmostEmpty")
    INSERTER_ALMOST_EMPTY("inserterAlmostEmpty", "261"),

    @JsonProperty("inserterAlmostFull")
    INSERTER_ALMOST_FULL("inserterAlmostFull", "262"),

    @JsonProperty("inserterAtLimit")
    INSERTER_AT_LIMIT("inserterAtLimit", "263"),

    @JsonProperty("inserterClosed")
    INSERTER_CLOSED("inserterClosed", "264"),

    @JsonProperty("inserterConfigurationChange")
    INSERTER_CONFIGURATION_CHANGE("inserterConfigurationChange", "265"),

    @JsonProperty("inserterCoverClosed")
    INSERTER_COVER_CLOSED("inserterCoverClosed", "266"),

    @JsonProperty("inserterCoverOpen")
    INSERTER_COVER_OPEN("inserterCoverOpen", "267"),

    @JsonProperty("inserterEmpty")
    INSERTER_EMPTY("inserterEmpty", "268"),

    @JsonProperty("inserterFull")
    INSERTER_FULL("inserterFull", "269"),

    @JsonProperty("inserterInterlockClosed")
    INSERTER_INTERLOCK_CLOSED("inserterInterlockClosed", "270"),

    @JsonProperty("inserterInterlockOpen")
    INSERTER_INTERLOCK_OPEN("inserterInterlockOpen", "271"),

    @JsonProperty("inserterJam")
    INSERTER_JAM("inserterJam", "272"),

    @JsonProperty("inserterLifeAlmostOver")
    INSERTER_LIFE_ALMOST_OVER("inserterLifeAlmostOver", "273"),

    @JsonProperty("inserterLifeOver")
    INSERTER_LIFE_OVER("inserterLifeOver", "274"),

    @JsonProperty("inserterMemoryExhausted")
    INSERTER_MEMORY_EXHAUSTED("inserterMemoryExhausted", "275"),

    @JsonProperty("inserterMissing")
    INSERTER_MISSING("inserterMissing", "276"),

    @JsonProperty("inserterMotorFailure")
    INSERTER_MOTOR_FAILURE("inserterMotorFailure", "277"),

    @JsonProperty("inserterNearLimit")
    INSERTER_NEAR_LIMIT("inserterNearLimit", "278"),

    @JsonProperty("inserterOffline")
    INSERTER_OFFLINE("inserterOffline", "279"),

    @JsonProperty("inserterOpened")
    INSERTER_OPENED("inserterOpened", "280"),

    @JsonProperty("inserterOverTemperature")
    INSERTER_OVER_TEMPERATURE("inserterOverTemperature", "281"),

    @JsonProperty("inserterPowerSaver")
    INSERTER_POWER_SAVER("inserterPowerSaver", "282"),

    @JsonProperty("inserterRecoverableFailure")
    INSERTER_RECOVERABLE_FAILURE("inserterRecoverableFailure", "283"),

    @JsonProperty("inserterRecoverableStorage")
    INSERTER_RECOVERABLE_STORAGE("inserterRecoverableStorage", "284"),

    @JsonProperty("inserterRemoved")
    INSERTER_REMOVED("inserterRemoved", "285"),

    @JsonProperty("inserterResourceAdded")
    INSERTER_RESOURCE_ADDED("inserterResourceAdded", "286"),

    @JsonProperty("inserterResourceRemoved")
    INSERTER_RESOURCE_REMOVED("inserterResourceRemoved", "287"),

    @JsonProperty("inserterThermistorFailure")
    INSERTER_THERMISTOR_FAILURE("inserterThermistorFailure", "288"),

    @JsonProperty("inserterTimingFailure")
    INSERTER_TIMING_FAILURE("inserterTimingFailure", "289"),

    @JsonProperty("inserterTurnedOff")
    INSERTER_TURNED_OFF("inserterTurnedOff", "290"),

    @JsonProperty("inserterTurnedOn")
    INSERTER_TURNED_ON("inserterTurnedOn", "291"),

    @JsonProperty("inserterUnderTemperature")
    INSERTER_UNDER_TEMPERATURE("inserterUnderTemperature", "292"),

    @JsonProperty("inserterUnrecoverableFailure")
    INSERTER_UNRECOVERABLE_FAILURE("inserterUnrecoverableFailure", "293"),

    @JsonProperty("inserterUnrecoverableStorageError")
    INSERTER_UNRECOVERABLE_STORAGE_ERROR("inserterUnrecoverableStorageError", "294"),

    @JsonProperty("inserterWarmingUp")
    INSERTER_WARMING_UP("inserterWarmingUp", "295"),

    @JsonProperty("interlockClosed")
    INTERLOCK_CLOSED("interlockClosed", "296"),

    @JsonProperty("interpreterCartridgeAdded")
    INTERPRETER_CARTRIDGE_ADDED("interpreterCartridgeAdded", "297"),

    @JsonProperty("interpreterCartridgeDeleted")
    INTERPRETER_CARTRIDGE_DELETED("interpreterCartridgeDeleted", "298"),

    @JsonProperty("interpreterComplexPageEncountered")
    INTERPRETER_COMPLEX_PAGE_ENCOUNTERED("interpreterComplexPageEncountered", "299"),

    @JsonProperty("interpreterMemoryDecrease")
    INTERPRETER_MEMORY_DECREASE("interpreterMemoryDecrease", "300"),

    @JsonProperty("interpreterMemoryIncrease")
    INTERPRETER_MEMORY_INCREASE("interpreterMemoryIncrease", "301"),

    @JsonProperty("interpreterResourceAdded")
    INTERPRETER_RESOURCE_ADDED("interpreterResourceAdded", "302"),

    @JsonProperty("interpreterResourceDeleted")
    INTERPRETER_RESOURCE_DELETED("interpreterResourceDeleted", "303"),

    @JsonProperty("lampAtEol")
    LAMP_AT_EOL("lampAtEol", "304"),

    @JsonProperty("lampFailure")
    LAMP_FAILURE("lampFailure", "305"),

    @JsonProperty("lampNearEol")
    LAMP_NEAR_EOL("lampNearEol", "306"),

    @JsonProperty("laserAtEol")
    LASER_AT_EOL("laserAtEol", "307"),

    @JsonProperty("laserFailure")
    LASER_FAILURE("laserFailure", "308"),

    @JsonProperty("laserNearEol")
    LASER_NEAR_EOL("laserNearEol", "309"),

    @JsonProperty("makeEnvelopeAdded")
    MAKE_ENVELOPE_ADDED("makeEnvelopeAdded", "310"),

    @JsonProperty("makeEnvelopeAlmostEmpty")
    MAKE_ENVELOPE_ALMOST_EMPTY("makeEnvelopeAlmostEmpty", "311"),

    @JsonProperty("makeEnvelopeAlmostFull")
    MAKE_ENVELOPE_ALMOST_FULL("makeEnvelopeAlmostFull", "312"),

    @JsonProperty("makeEnvelopeAtLimit")
    MAKE_ENVELOPE_AT_LIMIT("makeEnvelopeAtLimit", "313"),

    @JsonProperty("makeEnvelopeClosed")
    MAKE_ENVELOPE_CLOSED("makeEnvelopeClosed", "314"),

    @JsonProperty("makeEnvelopeConfigurationChange")
    MAKE_ENVELOPE_CONFIGURATION_CHANGE("makeEnvelopeConfigurationChange", "315"),

    @JsonProperty("makeEnvelopeCoverClosed")
    MAKE_ENVELOPE_COVER_CLOSED("makeEnvelopeCoverClosed", "316"),

    @JsonProperty("makeEnvelopeCoverOpen")
    MAKE_ENVELOPE_COVER_OPEN("makeEnvelopeCoverOpen", "317"),

    @JsonProperty("makeEnvelopeEmpty")
    MAKE_ENVELOPE_EMPTY("makeEnvelopeEmpty", "318"),

    @JsonProperty("makeEnvelopeFull")
    MAKE_ENVELOPE_FULL("makeEnvelopeFull", "319"),

    @JsonProperty("makeEnvelopeInterlockClosed")
    MAKE_ENVELOPE_INTERLOCK_CLOSED("makeEnvelopeInterlockClosed", "320"),

    @JsonProperty("makeEnvelopeInterlockOpen")
    MAKE_ENVELOPE_INTERLOCK_OPEN("makeEnvelopeInterlockOpen", "321"),

    @JsonProperty("makeEnvelopeJam")
    MAKE_ENVELOPE_JAM("makeEnvelopeJam", "322"),

    @JsonProperty("makeEnvelopeLifeAlmostOver")
    MAKE_ENVELOPE_LIFE_ALMOST_OVER("makeEnvelopeLifeAlmostOver", "323"),

    @JsonProperty("makeEnvelopeLifeOver")
    MAKE_ENVELOPE_LIFE_OVER("makeEnvelopeLifeOver", "324"),

    @JsonProperty("makeEnvelopeMemoryExhausted")
    MAKE_ENVELOPE_MEMORY_EXHAUSTED("makeEnvelopeMemoryExhausted", "325"),

    @JsonProperty("makeEnvelopeMissing")
    MAKE_ENVELOPE_MISSING("makeEnvelopeMissing", "326"),

    @JsonProperty("makeEnvelopeMotorFailure")
    MAKE_ENVELOPE_MOTOR_FAILURE("makeEnvelopeMotorFailure", "327"),

    @JsonProperty("makeEnvelopeNearLimit")
    MAKE_ENVELOPE_NEAR_LIMIT("makeEnvelopeNearLimit", "328"),

    @JsonProperty("makeEnvelopeOffline")
    MAKE_ENVELOPE_OFFLINE("makeEnvelopeOffline", "329"),

    @JsonProperty("makeEnvelopeOpened")
    MAKE_ENVELOPE_OPENED("makeEnvelopeOpened", "330"),

    @JsonProperty("makeEnvelopeOverTemperature")
    MAKE_ENVELOPE_OVER_TEMPERATURE("makeEnvelopeOverTemperature", "331"),

    @JsonProperty("makeEnvelopePowerSaver")
    MAKE_ENVELOPE_POWER_SAVER("makeEnvelopePowerSaver", "332"),

    @JsonProperty("makeEnvelopeRecoverableFailure")
    MAKE_ENVELOPE_RECOVERABLE_FAILURE("makeEnvelopeRecoverableFailure", "333"),

    @JsonProperty("makeEnvelopeRecoverableStorage")
    MAKE_ENVELOPE_RECOVERABLE_STORAGE("makeEnvelopeRecoverableStorage", "334"),

    @JsonProperty("makeEnvelopeRemoved")
    MAKE_ENVELOPE_REMOVED("makeEnvelopeRemoved", "335"),

    @JsonProperty("makeEnvelopeResourceAdded")
    MAKE_ENVELOPE_RESOURCE_ADDED("makeEnvelopeResourceAdded", "336"),

    @JsonProperty("makeEnvelopeResourceRemoved")
    MAKE_ENVELOPE_RESOURCE_REMOVED("makeEnvelopeResourceRemoved", "337"),

    @JsonProperty("makeEnvelopeThermistorFailure")
    MAKE_ENVELOPE_THERMISTOR_FAILURE("makeEnvelopeThermistorFailure", "338"),

    @JsonProperty("makeEnvelopeTimingFailure")
    MAKE_ENVELOPE_TIMING_FAILURE("makeEnvelopeTimingFailure", "339"),

    @JsonProperty("makeEnvelopeTurnedOff")
    MAKE_ENVELOPE_TURNED_OFF("makeEnvelopeTurnedOff", "340"),

    @JsonProperty("makeEnvelopeTurnedOn")
    MAKE_ENVELOPE_TURNED_ON("makeEnvelopeTurnedOn", "341"),

    @JsonProperty("makeEnvelopeUnderTemperature")
    MAKE_ENVELOPE_UNDER_TEMPERATURE("makeEnvelopeUnderTemperature", "342"),

    @JsonProperty("makeEnvelopeUnrecoverableFailure")
    MAKE_ENVELOPE_UNRECOVERABLE_FAILURE("makeEnvelopeUnrecoverableFailure", "343"),

    @JsonProperty("makeEnvelopeUnrecoverableStorageError")
    MAKE_ENVELOPE_UNRECOVERABLE_STORAGE_ERROR("makeEnvelopeUnrecoverableStorageError", "344"),

    @JsonProperty("makeEnvelopeWarmingUp")
    MAKE_ENVELOPE_WARMING_UP("makeEnvelopeWarmingUp", "345"),

    @JsonProperty("markerAdjustingPrintQuality")
    MARKER_ADJUSTING_PRINT_QUALITY("markerAdjustingPrintQuality", "346"),

    @JsonProperty("markerCleanerMissing")
    MARKER_CLEANER_MISSING("markerCleanerMissing", "347"),

    @JsonProperty("markerDeveloperAlmostEmpty")
    MARKER_DEVELOPER_ALMOST_EMPTY("markerDeveloperAlmostEmpty", "348"),

    @JsonProperty("markerDeveloperEmpty")
    MARKER_DEVELOPER_EMPTY("markerDeveloperEmpty", "349"),

    @JsonProperty("markerDeveloperMissing")
    MARKER_DEVELOPER_MISSING("markerDeveloperMissing", "350"),

    @JsonProperty("markerFuserMissing")
    MARKER_FUSER_MISSING("markerFuserMissing", "351"),

    @JsonProperty("markerFuserThermistorFailure")
    MARKER_FUSER_THERMISTOR_FAILURE("markerFuserThermistorFailure", "352"),

    @JsonProperty("markerFuserTimingFailure")
    MARKER_FUSER_TIMING_FAILURE("markerFuserTimingFailure", "353"),

    @JsonProperty("markerInkAlmostEmpty")
    MARKER_INK_ALMOST_EMPTY("markerInkAlmostEmpty", "354"),

    @JsonProperty("markerInkEmpty")
    MARKER_INK_EMPTY("markerInkEmpty", "355"),

    @JsonProperty("markerInkMissing")
    MARKER_INK_MISSING("markerInkMissing", "356"),

    @JsonProperty("markerOpcMissing")
    MARKER_OPC_MISSING("markerOpcMissing", "357"),

    @JsonProperty("markerPrintRibbonAlmostEmpty")
    MARKER_PRINT_RIBBON_ALMOST_EMPTY("markerPrintRibbonAlmostEmpty", "358"),

    @JsonProperty("markerPrintRibbonEmpty")
    MARKER_PRINT_RIBBON_EMPTY("markerPrintRibbonEmpty", "359"),

    @JsonProperty("markerPrintRibbonMissing")
    MARKER_PRINT_RIBBON_MISSING("markerPrintRibbonMissing", "360"),

    @JsonProperty("markerSupplyAlmostEmpty")
    MARKER_SUPPLY_ALMOST_EMPTY("markerSupplyAlmostEmpty", "361"),

    @JsonProperty("markerSupplyMissing")
    MARKER_SUPPLY_MISSING("markerSupplyMissing", "362"),

    @JsonProperty("markerTonerCartridgeMissing")
    MARKER_TONER_CARTRIDGE_MISSING("markerTonerCartridgeMissing", "363"),

    @JsonProperty("markerTonerMissing")
    MARKER_TONER_MISSING("markerTonerMissing", "364"),

    @JsonProperty("markerWasteInkReceptacleAlmostFull")
    MARKER_WASTE_INK_RECEPTACLE_ALMOST_FULL("markerWasteInkReceptacleAlmostFull", "365"),

    @JsonProperty("markerWasteInkReceptacleFull")
    MARKER_WASTE_INK_RECEPTACLE_FULL("markerWasteInkReceptacleFull", "366"),

    @JsonProperty("markerWasteInkReceptacleMissing")
    MARKER_WASTE_INK_RECEPTACLE_MISSING("markerWasteInkReceptacleMissing", "367"),

    @JsonProperty("markerWasteMissing")
    MARKER_WASTE_MISSING("markerWasteMissing", "368"),

    @JsonProperty("markerWasteTonerReceptacleAlmostFull")
    MARKER_WASTE_TONER_RECEPTACLE_ALMOST_FULL("markerWasteTonerReceptacleAlmostFull", "369"),

    @JsonProperty("markerWasteTonerReceptacleFull")
    MARKER_WASTE_TONER_RECEPTACLE_FULL("markerWasteTonerReceptacleFull", "370"),

    @JsonProperty("markerWasteTonerReceptacleMissing")
    MARKER_WASTE_TONER_RECEPTACLE_MISSING("markerWasteTonerReceptacleMissing", "371"),

    @JsonProperty("materialEmpty")
    MATERIAL_EMPTY("materialEmpty", "372"),

    @JsonProperty("materialLow")
    MATERIAL_LOW("materialLow", "373"),

    @JsonProperty("materialNeeded")
    MATERIAL_NEEDED("materialNeeded", "374"),

    @JsonProperty("mediaDrying")
    MEDIA_DRYING("mediaDrying", "375"),

    @JsonProperty("mediaPathCannotDuplexMediaSelected")
    MEDIA_PATH_CANNOT_DUPLEX_MEDIA_SELECTED("mediaPathCannotDuplexMediaSelected", "376"),

    @JsonProperty("mediaPathFailure")
    MEDIA_PATH_FAILURE("mediaPathFailure", "377"),

    @JsonProperty("mediaPathInputEmpty")
    MEDIA_PATH_INPUT_EMPTY("mediaPathInputEmpty", "378"),

    @JsonProperty("mediaPathInputFeedError")
    MEDIA_PATH_INPUT_FEED_ERROR("mediaPathInputFeedError", "379"),

    @JsonProperty("mediaPathInputJam")
    MEDIA_PATH_INPUT_JAM("mediaPathInputJam", "380"),

    @JsonProperty("mediaPathInputRequest")
    MEDIA_PATH_INPUT_REQUEST("mediaPathInputRequest", "381"),

    @JsonProperty("mediaPathJam")
    MEDIA_PATH_JAM("mediaPathJam", "382"),

    @JsonProperty("mediaPathMediaTrayAlmostFull")
    MEDIA_PATH_MEDIA_TRAY_ALMOST_FULL("mediaPathMediaTrayAlmostFull", "383"),

    @JsonProperty("mediaPathMediaTrayFull")
    MEDIA_PATH_MEDIA_TRAY_FULL("mediaPathMediaTrayFull", "384"),

    @JsonProperty("mediaPathMediaTrayMissing")
    MEDIA_PATH_MEDIA_TRAY_MISSING("mediaPathMediaTrayMissing", "385"),

    @JsonProperty("mediaPathOutputFeedError")
    MEDIA_PATH_OUTPUT_FEED_ERROR("mediaPathOutputFeedError", "386"),

    @JsonProperty("mediaPathOutputFull")
    MEDIA_PATH_OUTPUT_FULL("mediaPathOutputFull", "387"),

    @JsonProperty("mediaPathOutputJam")
    MEDIA_PATH_OUTPUT_JAM("mediaPathOutputJam", "388"),

    @JsonProperty("mediaPathPickRollerFailure")
    MEDIA_PATH_PICK_ROLLER_FAILURE("mediaPathPickRollerFailure", "389"),

    @JsonProperty("mediaPathPickRollerLifeOver")
    MEDIA_PATH_PICK_ROLLER_LIFE_OVER("mediaPathPickRollerLifeOver", "390"),

    @JsonProperty("mediaPathPickRollerLifeWarn")
    MEDIA_PATH_PICK_ROLLER_LIFE_WARN("mediaPathPickRollerLifeWarn", "391"),

    @JsonProperty("mediaPathPickRollerMissing")
    MEDIA_PATH_PICK_ROLLER_MISSING("mediaPathPickRollerMissing", "392"),

    @JsonProperty("motorFailure")
    MOTOR_FAILURE("motorFailure", "393"),

    @JsonProperty("outputMailboxSelectFailure")
    OUTPUT_MAILBOX_SELECT_FAILURE("outputMailboxSelectFailure", "394"),

    @JsonProperty("outputMediaTrayFailure")
    OUTPUT_MEDIA_TRAY_FAILURE("outputMediaTrayFailure", "395"),

    @JsonProperty("outputMediaTrayFeedError")
    OUTPUT_MEDIA_TRAY_FEED_ERROR("outputMediaTrayFeedError", "396"),

    @JsonProperty("outputMediaTrayJam")
    OUTPUT_MEDIA_TRAY_JAM("outputMediaTrayJam", "397"),

    @JsonProperty("perforaterAdded")
    PERFORATER_ADDED("perforaterAdded", "398"),

    @JsonProperty("perforaterAlmostEmpty")
    PERFORATER_ALMOST_EMPTY("perforaterAlmostEmpty", "399"),

    @JsonProperty("perforaterAlmostFull")
    PERFORATER_ALMOST_FULL("perforaterAlmostFull", "400"),

    @JsonProperty("perforaterAtLimit")
    PERFORATER_AT_LIMIT("perforaterAtLimit", "401"),

    @JsonProperty("perforaterClosed")
    PERFORATER_CLOSED("perforaterClosed", "402"),

    @JsonProperty("perforaterConfigurationChange")
    PERFORATER_CONFIGURATION_CHANGE("perforaterConfigurationChange", "403"),

    @JsonProperty("perforaterCoverClosed")
    PERFORATER_COVER_CLOSED("perforaterCoverClosed", "404"),

    @JsonProperty("perforaterCoverOpen")
    PERFORATER_COVER_OPEN("perforaterCoverOpen", "405"),

    @JsonProperty("perforaterEmpty")
    PERFORATER_EMPTY("perforaterEmpty", "406"),

    @JsonProperty("perforaterFull")
    PERFORATER_FULL("perforaterFull", "407"),

    @JsonProperty("perforaterInterlockClosed")
    PERFORATER_INTERLOCK_CLOSED("perforaterInterlockClosed", "408"),

    @JsonProperty("perforaterInterlockOpen")
    PERFORATER_INTERLOCK_OPEN("perforaterInterlockOpen", "409"),

    @JsonProperty("perforaterJam")
    PERFORATER_JAM("perforaterJam", "410"),

    @JsonProperty("perforaterLifeAlmostOver")
    PERFORATER_LIFE_ALMOST_OVER("perforaterLifeAlmostOver", "411"),

    @JsonProperty("perforaterLifeOver")
    PERFORATER_LIFE_OVER("perforaterLifeOver", "412"),

    @JsonProperty("perforaterMemoryExhausted")
    PERFORATER_MEMORY_EXHAUSTED("perforaterMemoryExhausted", "413"),

    @JsonProperty("perforaterMissing")
    PERFORATER_MISSING("perforaterMissing", "414"),

    @JsonProperty("perforaterMotorFailure")
    PERFORATER_MOTOR_FAILURE("perforaterMotorFailure", "415"),

    @JsonProperty("perforaterNearLimit")
    PERFORATER_NEAR_LIMIT("perforaterNearLimit", "416"),

    @JsonProperty("perforaterOffline")
    PERFORATER_OFFLINE("perforaterOffline", "417"),

    @JsonProperty("perforaterOpened")
    PERFORATER_OPENED("perforaterOpened", "418"),

    @JsonProperty("perforaterOverTemperature")
    PERFORATER_OVER_TEMPERATURE("perforaterOverTemperature", "419"),

    @JsonProperty("perforaterPowerSaver")
    PERFORATER_POWER_SAVER("perforaterPowerSaver", "420"),

    @JsonProperty("perforaterRecoverableFailure")
    PERFORATER_RECOVERABLE_FAILURE("perforaterRecoverableFailure", "421"),

    @JsonProperty("perforaterRecoverableStorage")
    PERFORATER_RECOVERABLE_STORAGE("perforaterRecoverableStorage", "422"),

    @JsonProperty("perforaterRemoved")
    PERFORATER_REMOVED("perforaterRemoved", "423"),

    @JsonProperty("perforaterResourceAdded")
    PERFORATER_RESOURCE_ADDED("perforaterResourceAdded", "424"),

    @JsonProperty("perforaterResourceRemoved")
    PERFORATER_RESOURCE_REMOVED("perforaterResourceRemoved", "425"),

    @JsonProperty("perforaterThermistorFailure")
    PERFORATER_THERMISTOR_FAILURE("perforaterThermistorFailure", "426"),

    @JsonProperty("perforaterTimingFailure")
    PERFORATER_TIMING_FAILURE("perforaterTimingFailure", "427"),

    @JsonProperty("perforaterTurnedOff")
    PERFORATER_TURNED_OFF("perforaterTurnedOff", "428"),

    @JsonProperty("perforaterTurnedOn")
    PERFORATER_TURNED_ON("perforaterTurnedOn", "429"),

    @JsonProperty("perforaterUnderTemperature")
    PERFORATER_UNDER_TEMPERATURE("perforaterUnderTemperature", "430"),

    @JsonProperty("perforaterUnrecoverableFailure")
    PERFORATER_UNRECOVERABLE_FAILURE("perforaterUnrecoverableFailure", "431"),

    @JsonProperty("perforaterUnrecoverableStorageError")
    PERFORATER_UNRECOVERABLE_STORAGE_ERROR("perforaterUnrecoverableStorageError", "432"),

    @JsonProperty("perforaterWarmingUp")
    PERFORATER_WARMING_UP("perforaterWarmingUp", "433"),

    @JsonProperty("platformCooling")
    PLATFORM_COOLING("platformCooling", "434"),

    @JsonProperty("platformFailure")
    PLATFORM_FAILURE("platformFailure", "435"),

    @JsonProperty("platformHeating")
    PLATFORM_HEATING("platformHeating", "436"),

    @JsonProperty("platformTemperatureHigh")
    PLATFORM_TEMPERATURE_HIGH("platformTemperatureHigh", "437"),

    @JsonProperty("platformTemperatureLow")
    PLATFORM_TEMPERATURE_LOW("platformTemperatureLow", "438"),

    @JsonProperty("powerDown")
    POWER_DOWN("powerDown", "439"),

    @JsonProperty("powerUp")
    POWER_UP("powerUp", "440"),

    @JsonProperty("printerManualReset")
    PRINTER_MANUAL_RESET("printerManualReset", "441"),

    @JsonProperty("printerNmsReset")
    PRINTER_NMS_RESET("printerNmsReset", "442"),

    @JsonProperty("printerReadyToPrint")
    PRINTER_READY_TO_PRINT("printerReadyToPrint", "443"),

    @JsonProperty("puncherAdded")
    PUNCHER_ADDED("puncherAdded", "444"),

    @JsonProperty("puncherAlmostEmpty")
    PUNCHER_ALMOST_EMPTY("puncherAlmostEmpty", "445"),

    @JsonProperty("puncherAlmostFull")
    PUNCHER_ALMOST_FULL("puncherAlmostFull", "446"),

    @JsonProperty("puncherAtLimit")
    PUNCHER_AT_LIMIT("puncherAtLimit", "447"),

    @JsonProperty("puncherClosed")
    PUNCHER_CLOSED("puncherClosed", "448"),

    @JsonProperty("puncherConfigurationChange")
    PUNCHER_CONFIGURATION_CHANGE("puncherConfigurationChange", "449"),

    @JsonProperty("puncherCoverClosed")
    PUNCHER_COVER_CLOSED("puncherCoverClosed", "450"),

    @JsonProperty("puncherCoverOpen")
    PUNCHER_COVER_OPEN("puncherCoverOpen", "451"),

    @JsonProperty("puncherEmpty")
    PUNCHER_EMPTY("puncherEmpty", "452"),

    @JsonProperty("puncherFull")
    PUNCHER_FULL("puncherFull", "453"),

    @JsonProperty("puncherInterlockClosed")
    PUNCHER_INTERLOCK_CLOSED("puncherInterlockClosed", "454"),

    @JsonProperty("puncherInterlockOpen")
    PUNCHER_INTERLOCK_OPEN("puncherInterlockOpen", "455"),

    @JsonProperty("puncherJam")
    PUNCHER_JAM("puncherJam", "456"),

    @JsonProperty("puncherLifeAlmostOver")
    PUNCHER_LIFE_ALMOST_OVER("puncherLifeAlmostOver", "457"),

    @JsonProperty("puncherLifeOver")
    PUNCHER_LIFE_OVER("puncherLifeOver", "458"),

    @JsonProperty("puncherMemoryExhausted")
    PUNCHER_MEMORY_EXHAUSTED("puncherMemoryExhausted", "459"),

    @JsonProperty("puncherMissing")
    PUNCHER_MISSING("puncherMissing", "460"),

    @JsonProperty("puncherMotorFailure")
    PUNCHER_MOTOR_FAILURE("puncherMotorFailure", "461"),

    @JsonProperty("puncherNearLimit")
    PUNCHER_NEAR_LIMIT("puncherNearLimit", "462"),

    @JsonProperty("puncherOffline")
    PUNCHER_OFFLINE("puncherOffline", "463"),

    @JsonProperty("puncherOpened")
    PUNCHER_OPENED("puncherOpened", "464"),

    @JsonProperty("puncherOverTemperature")
    PUNCHER_OVER_TEMPERATURE("puncherOverTemperature", "465"),

    @JsonProperty("puncherPowerSaver")
    PUNCHER_POWER_SAVER("puncherPowerSaver", "466"),

    @JsonProperty("puncherRecoverableFailure")
    PUNCHER_RECOVERABLE_FAILURE("puncherRecoverableFailure", "467"),

    @JsonProperty("puncherRecoverableStorage")
    PUNCHER_RECOVERABLE_STORAGE("puncherRecoverableStorage", "468"),

    @JsonProperty("puncherRemoved")
    PUNCHER_REMOVED("puncherRemoved", "469"),

    @JsonProperty("puncherResourceAdded")
    PUNCHER_RESOURCE_ADDED("puncherResourceAdded", "470"),

    @JsonProperty("puncherResourceRemoved")
    PUNCHER_RESOURCE_REMOVED("puncherResourceRemoved", "471"),

    @JsonProperty("puncherThermistorFailure")
    PUNCHER_THERMISTOR_FAILURE("puncherThermistorFailure", "472"),

    @JsonProperty("puncherTimingFailure")
    PUNCHER_TIMING_FAILURE("puncherTimingFailure", "473"),

    @JsonProperty("puncherTurnedOff")
    PUNCHER_TURNED_OFF("puncherTurnedOff", "474"),

    @JsonProperty("puncherTurnedOn")
    PUNCHER_TURNED_ON("puncherTurnedOn", "475"),

    @JsonProperty("puncherUnderTemperature")
    PUNCHER_UNDER_TEMPERATURE("puncherUnderTemperature", "476"),

    @JsonProperty("puncherUnrecoverableFailure")
    PUNCHER_UNRECOVERABLE_FAILURE("puncherUnrecoverableFailure", "477"),

    @JsonProperty("puncherUnrecoverableStorageError")
    PUNCHER_UNRECOVERABLE_STORAGE_ERROR("puncherUnrecoverableStorageError", "478"),

    @JsonProperty("puncherWarmingUp")
    PUNCHER_WARMING_UP("puncherWarmingUp", "479"),

    @JsonProperty("resuming")
    RESUMING("resuming", "480"),

    @JsonProperty("scanMediaPathFailure")
    SCAN_MEDIA_PATH_FAILURE("scanMediaPathFailure", "481"),

    @JsonProperty("scanMediaPathInputEmpty")
    SCAN_MEDIA_PATH_INPUT_EMPTY("scanMediaPathInputEmpty", "482"),

    @JsonProperty("scanMediaPathInputFeedError")
    SCAN_MEDIA_PATH_INPUT_FEED_ERROR("scanMediaPathInputFeedError", "483"),

    @JsonProperty("scanMediaPathInputJam")
    SCAN_MEDIA_PATH_INPUT_JAM("scanMediaPathInputJam", "484"),

    @JsonProperty("scanMediaPathInputRequest")
    SCAN_MEDIA_PATH_INPUT_REQUEST("scanMediaPathInputRequest", "485"),

    @JsonProperty("scanMediaPathJam")
    SCAN_MEDIA_PATH_JAM("scanMediaPathJam", "486"),

    @JsonProperty("scanMediaPathOutputFeedError")
    SCAN_MEDIA_PATH_OUTPUT_FEED_ERROR("scanMediaPathOutputFeedError", "487"),

    @JsonProperty("scanMediaPathOutputFull")
    SCAN_MEDIA_PATH_OUTPUT_FULL("scanMediaPathOutputFull", "488"),

    @JsonProperty("scanMediaPathOutputJam")
    SCAN_MEDIA_PATH_OUTPUT_JAM("scanMediaPathOutputJam", "489"),

    @JsonProperty("scanMediaPathPickRollerFailure")
    SCAN_MEDIA_PATH_PICK_ROLLER_FAILURE("scanMediaPathPickRollerFailure", "490"),

    @JsonProperty("scanMediaPathPickRollerLifeOver")
    SCAN_MEDIA_PATH_PICK_ROLLER_LIFE_OVER("scanMediaPathPickRollerLifeOver", "491"),

    @JsonProperty("scanMediaPathPickRollerLifeWarn")
    SCAN_MEDIA_PATH_PICK_ROLLER_LIFE_WARN("scanMediaPathPickRollerLifeWarn", "492"),

    @JsonProperty("scanMediaPathPickRollerMissing")
    SCAN_MEDIA_PATH_PICK_ROLLER_MISSING("scanMediaPathPickRollerMissing", "493"),

    @JsonProperty("scanMediaPathTrayAlmostFull")
    SCAN_MEDIA_PATH_TRAY_ALMOST_FULL("scanMediaPathTrayAlmostFull", "494"),

    @JsonProperty("scanMediaPathTrayFull")
    SCAN_MEDIA_PATH_TRAY_FULL("scanMediaPathTrayFull", "495"),

    @JsonProperty("scanMediaPathTrayMissing")
    SCAN_MEDIA_PATH_TRAY_MISSING("scanMediaPathTrayMissing", "496"),

    @JsonProperty("scannerLightFailure")
    SCANNER_LIGHT_FAILURE("scannerLightFailure", "497"),

    @JsonProperty("scannerLightLifeAlmostOver")
    SCANNER_LIGHT_LIFE_ALMOST_OVER("scannerLightLifeAlmostOver", "498"),

    @JsonProperty("scannerLightLifeOver")
    SCANNER_LIGHT_LIFE_OVER("scannerLightLifeOver", "499"),

    @JsonProperty("scannerLightMissing")
    SCANNER_LIGHT_MISSING("scannerLightMissing", "500"),

    @JsonProperty("scannerSensorFailure")
    SCANNER_SENSOR_FAILURE("scannerSensorFailure", "501"),

    @JsonProperty("scannerSensorLifeAlmostOver")
    SCANNER_SENSOR_LIFE_ALMOST_OVER("scannerSensorLifeAlmostOver", "502"),

    @JsonProperty("scannerSensorLifeOver")
    SCANNER_SENSOR_LIFE_OVER("scannerSensorLifeOver", "503"),

    @JsonProperty("scannerSensorMissing")
    SCANNER_SENSOR_MISSING("scannerSensorMissing", "504"),

    @JsonProperty("separationCutterAdded")
    SEPARATION_CUTTER_ADDED("separationCutterAdded", "505"),

    @JsonProperty("separationCutterAlmostEmpty")
    SEPARATION_CUTTER_ALMOST_EMPTY("separationCutterAlmostEmpty", "506"),

    @JsonProperty("separationCutterAlmostFull")
    SEPARATION_CUTTER_ALMOST_FULL("separationCutterAlmostFull", "507"),

    @JsonProperty("separationCutterAtLimit")
    SEPARATION_CUTTER_AT_LIMIT("separationCutterAtLimit", "508"),

    @JsonProperty("separationCutterClosed")
    SEPARATION_CUTTER_CLOSED("separationCutterClosed", "509"),

    @JsonProperty("separationCutterConfigurationChange")
    SEPARATION_CUTTER_CONFIGURATION_CHANGE("separationCutterConfigurationChange", "510"),

    @JsonProperty("separationCutterCoverClosed")
    SEPARATION_CUTTER_COVER_CLOSED("separationCutterCoverClosed", "511"),

    @JsonProperty("separationCutterCoverOpen")
    SEPARATION_CUTTER_COVER_OPEN("separationCutterCoverOpen", "512"),

    @JsonProperty("separationCutterEmpty")
    SEPARATION_CUTTER_EMPTY("separationCutterEmpty", "513"),

    @JsonProperty("separationCutterFull")
    SEPARATION_CUTTER_FULL("separationCutterFull", "514"),

    @JsonProperty("separationCutterInterlockClosed")
    SEPARATION_CUTTER_INTERLOCK_CLOSED("separationCutterInterlockClosed", "515"),

    @JsonProperty("separationCutterInterlockOpen")
    SEPARATION_CUTTER_INTERLOCK_OPEN("separationCutterInterlockOpen", "516"),

    @JsonProperty("separationCutterJam")
    SEPARATION_CUTTER_JAM("separationCutterJam", "517"),

    @JsonProperty("separationCutterLifeAlmostOver")
    SEPARATION_CUTTER_LIFE_ALMOST_OVER("separationCutterLifeAlmostOver", "518"),

    @JsonProperty("separationCutterLifeOver")
    SEPARATION_CUTTER_LIFE_OVER("separationCutterLifeOver", "519"),

    @JsonProperty("separationCutterMemoryExhausted")
    SEPARATION_CUTTER_MEMORY_EXHAUSTED("separationCutterMemoryExhausted", "520"),

    @JsonProperty("separationCutterMissing")
    SEPARATION_CUTTER_MISSING("separationCutterMissing", "521"),

    @JsonProperty("separationCutterMotorFailure")
    SEPARATION_CUTTER_MOTOR_FAILURE("separationCutterMotorFailure", "522"),

    @JsonProperty("separationCutterNearLimit")
    SEPARATION_CUTTER_NEAR_LIMIT("separationCutterNearLimit", "523"),

    @JsonProperty("separationCutterOffline")
    SEPARATION_CUTTER_OFFLINE("separationCutterOffline", "524"),

    @JsonProperty("separationCutterOpened")
    SEPARATION_CUTTER_OPENED("separationCutterOpened", "525"),

    @JsonProperty("separationCutterOverTemperature")
    SEPARATION_CUTTER_OVER_TEMPERATURE("separationCutterOverTemperature", "526"),

    @JsonProperty("separationCutterPowerSaver")
    SEPARATION_CUTTER_POWER_SAVER("separationCutterPowerSaver", "527"),

    @JsonProperty("separationCutterRecoverableFailure")
    SEPARATION_CUTTER_RECOVERABLE_FAILURE("separationCutterRecoverableFailure", "528"),

    @JsonProperty("separationCutterRecoverableStorage")
    SEPARATION_CUTTER_RECOVERABLE_STORAGE("separationCutterRecoverableStorage", "529"),

    @JsonProperty("separationCutterRemoved")
    SEPARATION_CUTTER_REMOVED("separationCutterRemoved", "530"),

    @JsonProperty("separationCutterResourceAdded")
    SEPARATION_CUTTER_RESOURCE_ADDED("separationCutterResourceAdded", "531"),

    @JsonProperty("separationCutterResourceRemoved")
    SEPARATION_CUTTER_RESOURCE_REMOVED("separationCutterResourceRemoved", "532"),

    @JsonProperty("separationCutterThermistorFailure")
    SEPARATION_CUTTER_THERMISTOR_FAILURE("separationCutterThermistorFailure", "533"),

    @JsonProperty("separationCutterTimingFailure")
    SEPARATION_CUTTER_TIMING_FAILURE("separationCutterTimingFailure", "534"),

    @JsonProperty("separationCutterTurnedOff")
    SEPARATION_CUTTER_TURNED_OFF("separationCutterTurnedOff", "535"),

    @JsonProperty("separationCutterTurnedOn")
    SEPARATION_CUTTER_TURNED_ON("separationCutterTurnedOn", "536"),

    @JsonProperty("separationCutterUnderTemperature")
    SEPARATION_CUTTER_UNDER_TEMPERATURE("separationCutterUnderTemperature", "537"),

    @JsonProperty("separationCutterUnrecoverableFailure")
    SEPARATION_CUTTER_UNRECOVERABLE_FAILURE("separationCutterUnrecoverableFailure", "538"),

    @JsonProperty("separationCutterUnrecoverableStorageError")
    SEPARATION_CUTTER_UNRECOVERABLE_STORAGE_ERROR("separationCutterUnrecoverableStorageError", "539"),

    @JsonProperty("separationCutterWarmingUp")
    SEPARATION_CUTTER_WARMING_UP("separationCutterWarmingUp", "540"),

    @JsonProperty("sheetRotatorAdded")
    SHEET_ROTATOR_ADDED("sheetRotatorAdded", "541"),

    @JsonProperty("sheetRotatorAlmostEmpty")
    SHEET_ROTATOR_ALMOST_EMPTY("sheetRotatorAlmostEmpty", "542"),

    @JsonProperty("sheetRotatorAlmostFull")
    SHEET_ROTATOR_ALMOST_FULL("sheetRotatorAlmostFull", "543"),

    @JsonProperty("sheetRotatorAtLimit")
    SHEET_ROTATOR_AT_LIMIT("sheetRotatorAtLimit", "544"),

    @JsonProperty("sheetRotatorClosed")
    SHEET_ROTATOR_CLOSED("sheetRotatorClosed", "545"),

    @JsonProperty("sheetRotatorConfigurationChange")
    SHEET_ROTATOR_CONFIGURATION_CHANGE("sheetRotatorConfigurationChange", "546"),

    @JsonProperty("sheetRotatorCoverClosed")
    SHEET_ROTATOR_COVER_CLOSED("sheetRotatorCoverClosed", "547"),

    @JsonProperty("sheetRotatorCoverOpen")
    SHEET_ROTATOR_COVER_OPEN("sheetRotatorCoverOpen", "548"),

    @JsonProperty("sheetRotatorEmpty")
    SHEET_ROTATOR_EMPTY("sheetRotatorEmpty", "549"),

    @JsonProperty("sheetRotatorFull")
    SHEET_ROTATOR_FULL("sheetRotatorFull", "550"),

    @JsonProperty("sheetRotatorInterlockClosed")
    SHEET_ROTATOR_INTERLOCK_CLOSED("sheetRotatorInterlockClosed", "551"),

    @JsonProperty("sheetRotatorInterlockOpen")
    SHEET_ROTATOR_INTERLOCK_OPEN("sheetRotatorInterlockOpen", "552"),

    @JsonProperty("sheetRotatorJam")
    SHEET_ROTATOR_JAM("sheetRotatorJam", "553"),

    @JsonProperty("sheetRotatorLifeAlmostOver")
    SHEET_ROTATOR_LIFE_ALMOST_OVER("sheetRotatorLifeAlmostOver", "554"),

    @JsonProperty("sheetRotatorLifeOver")
    SHEET_ROTATOR_LIFE_OVER("sheetRotatorLifeOver", "555"),

    @JsonProperty("sheetRotatorMemoryExhausted")
    SHEET_ROTATOR_MEMORY_EXHAUSTED("sheetRotatorMemoryExhausted", "556"),

    @JsonProperty("sheetRotatorMissing")
    SHEET_ROTATOR_MISSING("sheetRotatorMissing", "557"),

    @JsonProperty("sheetRotatorMotorFailure")
    SHEET_ROTATOR_MOTOR_FAILURE("sheetRotatorMotorFailure", "558"),

    @JsonProperty("sheetRotatorNearLimit")
    SHEET_ROTATOR_NEAR_LIMIT("sheetRotatorNearLimit", "559"),

    @JsonProperty("sheetRotatorOffline")
    SHEET_ROTATOR_OFFLINE("sheetRotatorOffline", "560"),

    @JsonProperty("sheetRotatorOpened")
    SHEET_ROTATOR_OPENED("sheetRotatorOpened", "561"),

    @JsonProperty("sheetRotatorOverTemperature")
    SHEET_ROTATOR_OVER_TEMPERATURE("sheetRotatorOverTemperature", "562"),

    @JsonProperty("sheetRotatorPowerSaver")
    SHEET_ROTATOR_POWER_SAVER("sheetRotatorPowerSaver", "563"),

    @JsonProperty("sheetRotatorRecoverableFailure")
    SHEET_ROTATOR_RECOVERABLE_FAILURE("sheetRotatorRecoverableFailure", "564"),

    @JsonProperty("sheetRotatorRecoverableStorage")
    SHEET_ROTATOR_RECOVERABLE_STORAGE("sheetRotatorRecoverableStorage", "565"),

    @JsonProperty("sheetRotatorRemoved")
    SHEET_ROTATOR_REMOVED("sheetRotatorRemoved", "566"),

    @JsonProperty("sheetRotatorResourceAdded")
    SHEET_ROTATOR_RESOURCE_ADDED("sheetRotatorResourceAdded", "567"),

    @JsonProperty("sheetRotatorResourceRemoved")
    SHEET_ROTATOR_RESOURCE_REMOVED("sheetRotatorResourceRemoved", "568"),

    @JsonProperty("sheetRotatorThermistorFailure")
    SHEET_ROTATOR_THERMISTOR_FAILURE("sheetRotatorThermistorFailure", "569"),

    @JsonProperty("sheetRotatorTimingFailure")
    SHEET_ROTATOR_TIMING_FAILURE("sheetRotatorTimingFailure", "570"),

    @JsonProperty("sheetRotatorTurnedOff")
    SHEET_ROTATOR_TURNED_OFF("sheetRotatorTurnedOff", "571"),

    @JsonProperty("sheetRotatorTurnedOn")
    SHEET_ROTATOR_TURNED_ON("sheetRotatorTurnedOn", "572"),

    @JsonProperty("sheetRotatorUnderTemperature")
    SHEET_ROTATOR_UNDER_TEMPERATURE("sheetRotatorUnderTemperature", "573"),

    @JsonProperty("sheetRotatorUnrecoverableFailure")
    SHEET_ROTATOR_UNRECOVERABLE_FAILURE("sheetRotatorUnrecoverableFailure", "574"),

    @JsonProperty("sheetRotatorUnrecoverableStorageError")
    SHEET_ROTATOR_UNRECOVERABLE_STORAGE_ERROR("sheetRotatorUnrecoverableStorageError", "575"),

    @JsonProperty("sheetRotatorWarmingUp")
    SHEET_ROTATOR_WARMING_UP("sheetRotatorWarmingUp", "576"),

    @JsonProperty("slitterAdded")
    SLITTER_ADDED("slitterAdded", "577"),

    @JsonProperty("slitterAlmostEmpty")
    SLITTER_ALMOST_EMPTY("slitterAlmostEmpty", "578"),

    @JsonProperty("slitterAlmostFull")
    SLITTER_ALMOST_FULL("slitterAlmostFull", "579"),

    @JsonProperty("slitterAtLimit")
    SLITTER_AT_LIMIT("slitterAtLimit", "580"),

    @JsonProperty("slitterClosed")
    SLITTER_CLOSED("slitterClosed", "581"),

    @JsonProperty("slitterConfigurationChange")
    SLITTER_CONFIGURATION_CHANGE("slitterConfigurationChange", "582"),

    @JsonProperty("slitterCoverClosed")
    SLITTER_COVER_CLOSED("slitterCoverClosed", "583"),

    @JsonProperty("slitterCoverOpen")
    SLITTER_COVER_OPEN("slitterCoverOpen", "584"),

    @JsonProperty("slitterEmpty")
    SLITTER_EMPTY("slitterEmpty", "585"),

    @JsonProperty("slitterFull")
    SLITTER_FULL("slitterFull", "586"),

    @JsonProperty("slitterInterlockClosed")
    SLITTER_INTERLOCK_CLOSED("slitterInterlockClosed", "587"),

    @JsonProperty("slitterInterlockOpen")
    SLITTER_INTERLOCK_OPEN("slitterInterlockOpen", "588"),

    @JsonProperty("slitterJam")
    SLITTER_JAM("slitterJam", "589"),

    @JsonProperty("slitterLifeAlmostOver")
    SLITTER_LIFE_ALMOST_OVER("slitterLifeAlmostOver", "590"),

    @JsonProperty("slitterLifeOver")
    SLITTER_LIFE_OVER("slitterLifeOver", "591"),

    @JsonProperty("slitterMemoryExhausted")
    SLITTER_MEMORY_EXHAUSTED("slitterMemoryExhausted", "592"),

    @JsonProperty("slitterMissing")
    SLITTER_MISSING("slitterMissing", "593"),

    @JsonProperty("slitterMotorFailure")
    SLITTER_MOTOR_FAILURE("slitterMotorFailure", "594"),

    @JsonProperty("slitterNearLimit")
    SLITTER_NEAR_LIMIT("slitterNearLimit", "595"),

    @JsonProperty("slitterOffline")
    SLITTER_OFFLINE("slitterOffline", "596"),

    @JsonProperty("slitterOpened")
    SLITTER_OPENED("slitterOpened", "597"),

    @JsonProperty("slitterOverTemperature")
    SLITTER_OVER_TEMPERATURE("slitterOverTemperature", "598"),

    @JsonProperty("slitterPowerSaver")
    SLITTER_POWER_SAVER("slitterPowerSaver", "599"),

    @JsonProperty("slitterRecoverableFailure")
    SLITTER_RECOVERABLE_FAILURE("slitterRecoverableFailure", "600"),

    @JsonProperty("slitterRecoverableStorage")
    SLITTER_RECOVERABLE_STORAGE("slitterRecoverableStorage", "601"),

    @JsonProperty("slitterRemoved")
    SLITTER_REMOVED("slitterRemoved", "602"),

    @JsonProperty("slitterResourceAdded")
    SLITTER_RESOURCE_ADDED("slitterResourceAdded", "603"),

    @JsonProperty("slitterResourceRemoved")
    SLITTER_RESOURCE_REMOVED("slitterResourceRemoved", "604"),

    @JsonProperty("slitterThermistorFailure")
    SLITTER_THERMISTOR_FAILURE("slitterThermistorFailure", "605"),

    @JsonProperty("slitterTimingFailure")
    SLITTER_TIMING_FAILURE("slitterTimingFailure", "606"),

    @JsonProperty("slitterTurnedOff")
    SLITTER_TURNED_OFF("slitterTurnedOff", "607"),

    @JsonProperty("slitterTurnedOn")
    SLITTER_TURNED_ON("slitterTurnedOn", "608"),

    @JsonProperty("slitterUnderTemperature")
    SLITTER_UNDER_TEMPERATURE("slitterUnderTemperature", "609"),

    @JsonProperty("slitterUnrecoverableFailure")
    SLITTER_UNRECOVERABLE_FAILURE("slitterUnrecoverableFailure", "610"),

    @JsonProperty("slitterUnrecoverableStorageError")
    SLITTER_UNRECOVERABLE_STORAGE_ERROR("slitterUnrecoverableStorageError", "611"),

    @JsonProperty("slitterWarmingUp")
    SLITTER_WARMING_UP("slitterWarmingUp", "612"),

    @JsonProperty("stackerAdded")
    STACKER_ADDED("stackerAdded", "613"),

    @JsonProperty("stackerAlmostEmpty")
    STACKER_ALMOST_EMPTY("stackerAlmostEmpty", "614"),

    @JsonProperty("stackerAlmostFull")
    STACKER_ALMOST_FULL("stackerAlmostFull", "615"),

    @JsonProperty("stackerAtLimit")
    STACKER_AT_LIMIT("stackerAtLimit", "616"),

    @JsonProperty("stackerClosed")
    STACKER_CLOSED("stackerClosed", "617"),

    @JsonProperty("stackerConfigurationChange")
    STACKER_CONFIGURATION_CHANGE("stackerConfigurationChange", "618"),

    @JsonProperty("stackerCoverClosed")
    STACKER_COVER_CLOSED("stackerCoverClosed", "619"),

    @JsonProperty("stackerCoverOpen")
    STACKER_COVER_OPEN("stackerCoverOpen", "620"),

    @JsonProperty("stackerEmpty")
    STACKER_EMPTY("stackerEmpty", "621"),

    @JsonProperty("stackerFull")
    STACKER_FULL("stackerFull", "622"),

    @JsonProperty("stackerInterlockClosed")
    STACKER_INTERLOCK_CLOSED("stackerInterlockClosed", "623"),

    @JsonProperty("stackerInterlockOpen")
    STACKER_INTERLOCK_OPEN("stackerInterlockOpen", "624"),

    @JsonProperty("stackerJam")
    STACKER_JAM("stackerJam", "625"),

    @JsonProperty("stackerLifeAlmostOver")
    STACKER_LIFE_ALMOST_OVER("stackerLifeAlmostOver", "626"),

    @JsonProperty("stackerLifeOver")
    STACKER_LIFE_OVER("stackerLifeOver", "627"),

    @JsonProperty("stackerMemoryExhausted")
    STACKER_MEMORY_EXHAUSTED("stackerMemoryExhausted", "628"),

    @JsonProperty("stackerMissing")
    STACKER_MISSING("stackerMissing", "629"),

    @JsonProperty("stackerMotorFailure")
    STACKER_MOTOR_FAILURE("stackerMotorFailure", "630"),

    @JsonProperty("stackerNearLimit")
    STACKER_NEAR_LIMIT("stackerNearLimit", "631"),

    @JsonProperty("stackerOffline")
    STACKER_OFFLINE("stackerOffline", "632"),

    @JsonProperty("stackerOpened")
    STACKER_OPENED("stackerOpened", "633"),

    @JsonProperty("stackerOverTemperature")
    STACKER_OVER_TEMPERATURE("stackerOverTemperature", "634"),

    @JsonProperty("stackerPowerSaver")
    STACKER_POWER_SAVER("stackerPowerSaver", "635"),

    @JsonProperty("stackerRecoverableFailure")
    STACKER_RECOVERABLE_FAILURE("stackerRecoverableFailure", "636"),

    @JsonProperty("stackerRecoverableStorage")
    STACKER_RECOVERABLE_STORAGE("stackerRecoverableStorage", "637"),

    @JsonProperty("stackerRemoved")
    STACKER_REMOVED("stackerRemoved", "638"),

    @JsonProperty("stackerResourceAdded")
    STACKER_RESOURCE_ADDED("stackerResourceAdded", "639"),

    @JsonProperty("stackerResourceRemoved")
    STACKER_RESOURCE_REMOVED("stackerResourceRemoved", "640"),

    @JsonProperty("stackerThermistorFailure")
    STACKER_THERMISTOR_FAILURE("stackerThermistorFailure", "641"),

    @JsonProperty("stackerTimingFailure")
    STACKER_TIMING_FAILURE("stackerTimingFailure", "642"),

    @JsonProperty("stackerTurnedOff")
    STACKER_TURNED_OFF("stackerTurnedOff", "643"),

    @JsonProperty("stackerTurnedOn")
    STACKER_TURNED_ON("stackerTurnedOn", "644"),

    @JsonProperty("stackerUnderTemperature")
    STACKER_UNDER_TEMPERATURE("stackerUnderTemperature", "645"),

    @JsonProperty("stackerUnrecoverableFailure")
    STACKER_UNRECOVERABLE_FAILURE("stackerUnrecoverableFailure", "646"),

    @JsonProperty("stackerUnrecoverableStorageError")
    STACKER_UNRECOVERABLE_STORAGE_ERROR("stackerUnrecoverableStorageError", "647"),

    @JsonProperty("stackerWarmingUp")
    STACKER_WARMING_UP("stackerWarmingUp", "648"),

    @JsonProperty("standby")
    STANDBY("standby", "649"),

    @JsonProperty("staplerAdded")
    STAPLER_ADDED("staplerAdded", "650"),

    @JsonProperty("staplerAlmostEmpty")
    STAPLER_ALMOST_EMPTY("staplerAlmostEmpty", "651"),

    @JsonProperty("staplerAlmostFull")
    STAPLER_ALMOST_FULL("staplerAlmostFull", "652"),

    @JsonProperty("staplerAtLimit")
    STAPLER_AT_LIMIT("staplerAtLimit", "653"),

    @JsonProperty("staplerClosed")
    STAPLER_CLOSED("staplerClosed", "654"),

    @JsonProperty("staplerConfigurationChange")
    STAPLER_CONFIGURATION_CHANGE("staplerConfigurationChange", "655"),

    @JsonProperty("staplerCoverClosed")
    STAPLER_COVER_CLOSED("staplerCoverClosed", "656"),

    @JsonProperty("staplerCoverOpen")
    STAPLER_COVER_OPEN("staplerCoverOpen", "657"),

    @JsonProperty("staplerEmpty")
    STAPLER_EMPTY("staplerEmpty", "658"),

    @JsonProperty("staplerFull")
    STAPLER_FULL("staplerFull", "659"),

    @JsonProperty("staplerInterlockClosed")
    STAPLER_INTERLOCK_CLOSED("staplerInterlockClosed", "660"),

    @JsonProperty("staplerInterlockOpen")
    STAPLER_INTERLOCK_OPEN("staplerInterlockOpen", "661"),

    @JsonProperty("staplerJam")
    STAPLER_JAM("staplerJam", "662"),

    @JsonProperty("staplerLifeAlmostOver")
    STAPLER_LIFE_ALMOST_OVER("staplerLifeAlmostOver", "663"),

    @JsonProperty("staplerLifeOver")
    STAPLER_LIFE_OVER("staplerLifeOver", "664"),

    @JsonProperty("staplerMemoryExhausted")
    STAPLER_MEMORY_EXHAUSTED("staplerMemoryExhausted", "665"),

    @JsonProperty("staplerMissing")
    STAPLER_MISSING("staplerMissing", "666"),

    @JsonProperty("staplerMotorFailure")
    STAPLER_MOTOR_FAILURE("staplerMotorFailure", "667"),

    @JsonProperty("staplerNearLimit")
    STAPLER_NEAR_LIMIT("staplerNearLimit", "668"),

    @JsonProperty("staplerOffline")
    STAPLER_OFFLINE("staplerOffline", "669"),

    @JsonProperty("staplerOpened")
    STAPLER_OPENED("staplerOpened", "670"),

    @JsonProperty("staplerOverTemperature")
    STAPLER_OVER_TEMPERATURE("staplerOverTemperature", "671"),

    @JsonProperty("staplerPowerSaver")
    STAPLER_POWER_SAVER("staplerPowerSaver", "672"),

    @JsonProperty("staplerRecoverableFailure")
    STAPLER_RECOVERABLE_FAILURE("staplerRecoverableFailure", "673"),

    @JsonProperty("staplerRecoverableStorage")
    STAPLER_RECOVERABLE_STORAGE("staplerRecoverableStorage", "674"),

    @JsonProperty("staplerRemoved")
    STAPLER_REMOVED("staplerRemoved", "675"),

    @JsonProperty("staplerResourceAdded")
    STAPLER_RESOURCE_ADDED("staplerResourceAdded", "676"),

    @JsonProperty("staplerResourceRemoved")
    STAPLER_RESOURCE_REMOVED("staplerResourceRemoved", "677"),

    @JsonProperty("staplerThermistorFailure")
    STAPLER_THERMISTOR_FAILURE("staplerThermistorFailure", "678"),

    @JsonProperty("staplerTimingFailure")
    STAPLER_TIMING_FAILURE("staplerTimingFailure", "679"),

    @JsonProperty("staplerTurnedOff")
    STAPLER_TURNED_OFF("staplerTurnedOff", "680"),

    @JsonProperty("staplerTurnedOn")
    STAPLER_TURNED_ON("staplerTurnedOn", "681"),

    @JsonProperty("staplerUnderTemperature")
    STAPLER_UNDER_TEMPERATURE("staplerUnderTemperature", "682"),

    @JsonProperty("staplerUnrecoverableFailure")
    STAPLER_UNRECOVERABLE_FAILURE("staplerUnrecoverableFailure", "683"),

    @JsonProperty("staplerUnrecoverableStorageError")
    STAPLER_UNRECOVERABLE_STORAGE_ERROR("staplerUnrecoverableStorageError", "684"),

    @JsonProperty("staplerWarmingUp")
    STAPLER_WARMING_UP("staplerWarmingUp", "685"),

    @JsonProperty("stitcherAdded")
    STITCHER_ADDED("stitcherAdded", "686"),

    @JsonProperty("stitcherAlmostEmpty")
    STITCHER_ALMOST_EMPTY("stitcherAlmostEmpty", "687"),

    @JsonProperty("stitcherAlmostFull")
    STITCHER_ALMOST_FULL("stitcherAlmostFull", "688"),

    @JsonProperty("stitcherAtLimit")
    STITCHER_AT_LIMIT("stitcherAtLimit", "689"),

    @JsonProperty("stitcherClosed")
    STITCHER_CLOSED("stitcherClosed", "690"),

    @JsonProperty("stitcherConfigurationChange")
    STITCHER_CONFIGURATION_CHANGE("stitcherConfigurationChange", "691"),

    @JsonProperty("stitcherCoverClosed")
    STITCHER_COVER_CLOSED("stitcherCoverClosed", "692"),

    @JsonProperty("stitcherCoverOpen")
    STITCHER_COVER_OPEN("stitcherCoverOpen", "693"),

    @JsonProperty("stitcherEmpty")
    STITCHER_EMPTY("stitcherEmpty", "694"),

    @JsonProperty("stitcherFull")
    STITCHER_FULL("stitcherFull", "695"),

    @JsonProperty("stitcherInterlockClosed")
    STITCHER_INTERLOCK_CLOSED("stitcherInterlockClosed", "696"),

    @JsonProperty("stitcherInterlockOpen")
    STITCHER_INTERLOCK_OPEN("stitcherInterlockOpen", "697"),

    @JsonProperty("stitcherJam")
    STITCHER_JAM("stitcherJam", "698"),

    @JsonProperty("stitcherLifeAlmostOver")
    STITCHER_LIFE_ALMOST_OVER("stitcherLifeAlmostOver", "699"),

    @JsonProperty("stitcherLifeOver")
    STITCHER_LIFE_OVER("stitcherLifeOver", "700"),

    @JsonProperty("stitcherMemoryExhausted")
    STITCHER_MEMORY_EXHAUSTED("stitcherMemoryExhausted", "701"),

    @JsonProperty("stitcherMissing")
    STITCHER_MISSING("stitcherMissing", "702"),

    @JsonProperty("stitcherMotorFailure")
    STITCHER_MOTOR_FAILURE("stitcherMotorFailure", "703"),

    @JsonProperty("stitcherNearLimit")
    STITCHER_NEAR_LIMIT("stitcherNearLimit", "704"),

    @JsonProperty("stitcherOffline")
    STITCHER_OFFLINE("stitcherOffline", "705"),

    @JsonProperty("stitcherOpened")
    STITCHER_OPENED("stitcherOpened", "706"),

    @JsonProperty("stitcherOverTemperature")
    STITCHER_OVER_TEMPERATURE("stitcherOverTemperature", "707"),

    @JsonProperty("stitcherPowerSaver")
    STITCHER_POWER_SAVER("stitcherPowerSaver", "708"),

    @JsonProperty("stitcherRecoverableFailure")
    STITCHER_RECOVERABLE_FAILURE("stitcherRecoverableFailure", "709"),

    @JsonProperty("stitcherRecoverableStorage")
    STITCHER_RECOVERABLE_STORAGE("stitcherRecoverableStorage", "710"),

    @JsonProperty("stitcherRemoved")
    STITCHER_REMOVED("stitcherRemoved", "711"),

    @JsonProperty("stitcherResourceAdded")
    STITCHER_RESOURCE_ADDED("stitcherResourceAdded", "712"),

    @JsonProperty("stitcherResourceRemoved")
    STITCHER_RESOURCE_REMOVED("stitcherResourceRemoved", "713"),

    @JsonProperty("stitcherThermistorFailure")
    STITCHER_THERMISTOR_FAILURE("stitcherThermistorFailure", "714"),

    @JsonProperty("stitcherTimingFailure")
    STITCHER_TIMING_FAILURE("stitcherTimingFailure", "715"),

    @JsonProperty("stitcherTurnedOff")
    STITCHER_TURNED_OFF("stitcherTurnedOff", "716"),

    @JsonProperty("stitcherTurnedOn")
    STITCHER_TURNED_ON("stitcherTurnedOn", "717"),

    @JsonProperty("stitcherUnderTemperature")
    STITCHER_UNDER_TEMPERATURE("stitcherUnderTemperature", "718"),

    @JsonProperty("stitcherUnrecoverableFailure")
    STITCHER_UNRECOVERABLE_FAILURE("stitcherUnrecoverableFailure", "719"),

    @JsonProperty("stitcherUnrecoverableStorageError")
    STITCHER_UNRECOVERABLE_STORAGE_ERROR("stitcherUnrecoverableStorageError", "720"),

    @JsonProperty("stitcherWarmingUp")
    STITCHER_WARMING_UP("stitcherWarmingUp", "721"),

    @JsonProperty("subunitAdded")
    SUBUNIT_ADDED("subunitAdded", "722"),

    @JsonProperty("subunitAlmostEmpty")
    SUBUNIT_ALMOST_EMPTY("subunitAlmostEmpty", "723"),

    @JsonProperty("subunitAlmostFull")
    SUBUNIT_ALMOST_FULL("subunitAlmostFull", "724"),

    @JsonProperty("subunitAtLimit")
    SUBUNIT_AT_LIMIT("subunitAtLimit", "725"),

    @JsonProperty("subunitClosed")
    SUBUNIT_CLOSED("subunitClosed", "726"),

    @JsonProperty("subunitCoolingDown")
    SUBUNIT_COOLING_DOWN("subunitCoolingDown", "727"),

    @JsonProperty("subunitEmpty")
    SUBUNIT_EMPTY("subunitEmpty", "728"),

    @JsonProperty("subunitFull")
    SUBUNIT_FULL("subunitFull", "729"),

    @JsonProperty("subunitLifeAlmostOver")
    SUBUNIT_LIFE_ALMOST_OVER("subunitLifeAlmostOver", "730"),

    @JsonProperty("subunitLifeOver")
    SUBUNIT_LIFE_OVER("subunitLifeOver", "731"),

    @JsonProperty("subunitMemoryExhausted")
    SUBUNIT_MEMORY_EXHAUSTED("subunitMemoryExhausted", "732"),

    @JsonProperty("subunitMissing")
    SUBUNIT_MISSING("subunitMissing", "733"),

    @JsonProperty("subunitMotorFailure")
    SUBUNIT_MOTOR_FAILURE("subunitMotorFailure", "734"),

    @JsonProperty("subunitNearLimit")
    SUBUNIT_NEAR_LIMIT("subunitNearLimit", "735"),

    @JsonProperty("subunitOffline")
    SUBUNIT_OFFLINE("subunitOffline", "736"),

    @JsonProperty("subunitOpened")
    SUBUNIT_OPENED("subunitOpened", "737"),

    @JsonProperty("subunitOverTemperature")
    SUBUNIT_OVER_TEMPERATURE("subunitOverTemperature", "738"),

    @JsonProperty("subunitPowerSaver")
    SUBUNIT_POWER_SAVER("subunitPowerSaver", "739"),

    @JsonProperty("subunitRecoverableFailure")
    SUBUNIT_RECOVERABLE_FAILURE("subunitRecoverableFailure", "740"),

    @JsonProperty("subunitRecoverableStorage")
    SUBUNIT_RECOVERABLE_STORAGE("subunitRecoverableStorage", "741"),

    @JsonProperty("subunitRemoved")
    SUBUNIT_REMOVED("subunitRemoved", "742"),

    @JsonProperty("subunitResourceAdded")
    SUBUNIT_RESOURCE_ADDED("subunitResourceAdded", "743"),

    @JsonProperty("subunitResourceRemoved")
    SUBUNIT_RESOURCE_REMOVED("subunitResourceRemoved", "744"),

    @JsonProperty("subunitThermistorFailure")
    SUBUNIT_THERMISTOR_FAILURE("subunitThermistorFailure", "745"),

    @JsonProperty("subunitTimingFailure")
    SUBUNIT_TIMING_FAILURE("subunitTimingFailure", "746"),

    @JsonProperty("subunitTurnedOff")
    SUBUNIT_TURNED_OFF("subunitTurnedOff", "747"),

    @JsonProperty("subunitTurnedOn")
    SUBUNIT_TURNED_ON("subunitTurnedOn", "748"),

    @JsonProperty("subunitUnderTemperature")
    SUBUNIT_UNDER_TEMPERATURE("subunitUnderTemperature", "749"),

    @JsonProperty("subunitUnrecoverableFailure")
    SUBUNIT_UNRECOVERABLE_FAILURE("subunitUnrecoverableFailure", "750"),

    @JsonProperty("subunitUnrecoverableStorage")
    SUBUNIT_UNRECOVERABLE_STORAGE("subunitUnrecoverableStorage", "751"),

    @JsonProperty("subunitWarmingUp")
    SUBUNIT_WARMING_UP("subunitWarmingUp", "752"),

    @JsonProperty("suspend")
    SUSPEND("suspend", "753"),

    @JsonProperty("testing")
    TESTING("testing", "754"),

    @JsonProperty("trimmerAdded")
    TRIMMER_ADDED("trimmerAdded", "755"),

    @JsonProperty("trimmerAlmostEmpty")
    TRIMMER_ALMOST_EMPTY("trimmerAlmostEmpty", "756"),

    @JsonProperty("trimmerAlmostFull")
    TRIMMER_ALMOST_FULL("trimmerAlmostFull", "757"),

    @JsonProperty("trimmerAtLimit")
    TRIMMER_AT_LIMIT("trimmerAtLimit", "758"),

    @JsonProperty("trimmerClosed")
    TRIMMER_CLOSED("trimmerClosed", "759"),

    @JsonProperty("trimmerConfigurationChange")
    TRIMMER_CONFIGURATION_CHANGE("trimmerConfigurationChange", "760"),

    @JsonProperty("trimmerCoverClosed")
    TRIMMER_COVER_CLOSED("trimmerCoverClosed", "761"),

    @JsonProperty("trimmerCoverOpen")
    TRIMMER_COVER_OPEN("trimmerCoverOpen", "762"),

    @JsonProperty("trimmerEmpty")
    TRIMMER_EMPTY("trimmerEmpty", "763"),

    @JsonProperty("trimmerFull")
    TRIMMER_FULL("trimmerFull", "764"),

    @JsonProperty("trimmerInterlockClosed")
    TRIMMER_INTERLOCK_CLOSED("trimmerInterlockClosed", "765"),

    @JsonProperty("trimmerInterlockOpen")
    TRIMMER_INTERLOCK_OPEN("trimmerInterlockOpen", "766"),

    @JsonProperty("trimmerJam")
    TRIMMER_JAM("trimmerJam", "767"),

    @JsonProperty("trimmerLifeAlmostOver")
    TRIMMER_LIFE_ALMOST_OVER("trimmerLifeAlmostOver", "768"),

    @JsonProperty("trimmerLifeOver")
    TRIMMER_LIFE_OVER("trimmerLifeOver", "769"),

    @JsonProperty("trimmerMemoryExhausted")
    TRIMMER_MEMORY_EXHAUSTED("trimmerMemoryExhausted", "770"),

    @JsonProperty("trimmerMissing")
    TRIMMER_MISSING("trimmerMissing", "771"),

    @JsonProperty("trimmerMotorFailure")
    TRIMMER_MOTOR_FAILURE("trimmerMotorFailure", "772"),

    @JsonProperty("trimmerNearLimit")
    TRIMMER_NEAR_LIMIT("trimmerNearLimit", "773"),

    @JsonProperty("trimmerOffline")
    TRIMMER_OFFLINE("trimmerOffline", "774"),

    @JsonProperty("trimmerOpened")
    TRIMMER_OPENED("trimmerOpened", "775"),

    @JsonProperty("trimmerOverTemperature")
    TRIMMER_OVER_TEMPERATURE("trimmerOverTemperature", "776"),

    @JsonProperty("trimmerPowerSaver")
    TRIMMER_POWER_SAVER("trimmerPowerSaver", "777"),

    @JsonProperty("trimmerRecoverableFailure")
    TRIMMER_RECOVERABLE_FAILURE("trimmerRecoverableFailure", "778"),

    @JsonProperty("trimmerRecoverableStorage")
    TRIMMER_RECOVERABLE_STORAGE("trimmerRecoverableStorage", "779"),

    @JsonProperty("trimmerRemoved")
    TRIMMER_REMOVED("trimmerRemoved", "780"),

    @JsonProperty("trimmerResourceAdded")
    TRIMMER_RESOURCE_ADDED("trimmerResourceAdded", "781"),

    @JsonProperty("trimmerResourceRemoved")
    TRIMMER_RESOURCE_REMOVED("trimmerResourceRemoved", "782"),

    @JsonProperty("trimmerThermistorFailure")
    TRIMMER_THERMISTOR_FAILURE("trimmerThermistorFailure", "783"),

    @JsonProperty("trimmerTimingFailure")
    TRIMMER_TIMING_FAILURE("trimmerTimingFailure", "784"),

    @JsonProperty("trimmerTurnedOff")
    TRIMMER_TURNED_OFF("trimmerTurnedOff", "785"),

    @JsonProperty("trimmerTurnedOn")
    TRIMMER_TURNED_ON("trimmerTurnedOn", "786"),

    @JsonProperty("trimmerUnderTemperature")
    TRIMMER_UNDER_TEMPERATURE("trimmerUnderTemperature", "787"),

    @JsonProperty("trimmerUnrecoverableFailure")
    TRIMMER_UNRECOVERABLE_FAILURE("trimmerUnrecoverableFailure", "788"),

    @JsonProperty("trimmerUnrecoverableStorageError")
    TRIMMER_UNRECOVERABLE_STORAGE_ERROR("trimmerUnrecoverableStorageError", "789"),

    @JsonProperty("trimmerWarmingUp")
    TRIMMER_WARMING_UP("trimmerWarmingUp", "790"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "791"),

    @JsonProperty("wrapperAdded")
    WRAPPER_ADDED("wrapperAdded", "792"),

    @JsonProperty("wrapperAlmostEmpty")
    WRAPPER_ALMOST_EMPTY("wrapperAlmostEmpty", "793"),

    @JsonProperty("wrapperAlmostFull")
    WRAPPER_ALMOST_FULL("wrapperAlmostFull", "794"),

    @JsonProperty("wrapperAtLimit")
    WRAPPER_AT_LIMIT("wrapperAtLimit", "795"),

    @JsonProperty("wrapperClosed")
    WRAPPER_CLOSED("wrapperClosed", "796"),

    @JsonProperty("wrapperConfigurationChange")
    WRAPPER_CONFIGURATION_CHANGE("wrapperConfigurationChange", "797"),

    @JsonProperty("wrapperCoverClosed")
    WRAPPER_COVER_CLOSED("wrapperCoverClosed", "798"),

    @JsonProperty("wrapperCoverOpen")
    WRAPPER_COVER_OPEN("wrapperCoverOpen", "799"),

    @JsonProperty("wrapperEmpty")
    WRAPPER_EMPTY("wrapperEmpty", "800"),

    @JsonProperty("wrapperFull")
    WRAPPER_FULL("wrapperFull", "801"),

    @JsonProperty("wrapperInterlockClosed")
    WRAPPER_INTERLOCK_CLOSED("wrapperInterlockClosed", "802"),

    @JsonProperty("wrapperInterlockOpen")
    WRAPPER_INTERLOCK_OPEN("wrapperInterlockOpen", "803"),

    @JsonProperty("wrapperJam")
    WRAPPER_JAM("wrapperJam", "804"),

    @JsonProperty("wrapperLifeAlmostOver")
    WRAPPER_LIFE_ALMOST_OVER("wrapperLifeAlmostOver", "805"),

    @JsonProperty("wrapperLifeOver")
    WRAPPER_LIFE_OVER("wrapperLifeOver", "806"),

    @JsonProperty("wrapperMemoryExhausted")
    WRAPPER_MEMORY_EXHAUSTED("wrapperMemoryExhausted", "807"),

    @JsonProperty("wrapperMissing")
    WRAPPER_MISSING("wrapperMissing", "808"),

    @JsonProperty("wrapperMotorFailure")
    WRAPPER_MOTOR_FAILURE("wrapperMotorFailure", "809"),

    @JsonProperty("wrapperNearLimit")
    WRAPPER_NEAR_LIMIT("wrapperNearLimit", "810"),

    @JsonProperty("wrapperOffline")
    WRAPPER_OFFLINE("wrapperOffline", "811"),

    @JsonProperty("wrapperOpened")
    WRAPPER_OPENED("wrapperOpened", "812"),

    @JsonProperty("wrapperOverTemperature")
    WRAPPER_OVER_TEMPERATURE("wrapperOverTemperature", "813"),

    @JsonProperty("wrapperPowerSaver")
    WRAPPER_POWER_SAVER("wrapperPowerSaver", "814"),

    @JsonProperty("wrapperRecoverableFailure")
    WRAPPER_RECOVERABLE_FAILURE("wrapperRecoverableFailure", "815"),

    @JsonProperty("wrapperRecoverableStorage")
    WRAPPER_RECOVERABLE_STORAGE("wrapperRecoverableStorage", "816"),

    @JsonProperty("wrapperRemoved")
    WRAPPER_REMOVED("wrapperRemoved", "817"),

    @JsonProperty("wrapperResourceAdded")
    WRAPPER_RESOURCE_ADDED("wrapperResourceAdded", "818"),

    @JsonProperty("wrapperResourceRemoved")
    WRAPPER_RESOURCE_REMOVED("wrapperResourceRemoved", "819"),

    @JsonProperty("wrapperThermistorFailure")
    WRAPPER_THERMISTOR_FAILURE("wrapperThermistorFailure", "820"),

    @JsonProperty("wrapperTimingFailure")
    WRAPPER_TIMING_FAILURE("wrapperTimingFailure", "821"),

    @JsonProperty("wrapperTurnedOff")
    WRAPPER_TURNED_OFF("wrapperTurnedOff", "822"),

    @JsonProperty("wrapperTurnedOn")
    WRAPPER_TURNED_ON("wrapperTurnedOn", "823"),

    @JsonProperty("wrapperUnderTemperature")
    WRAPPER_UNDER_TEMPERATURE("wrapperUnderTemperature", "824"),

    @JsonProperty("wrapperUnrecoverableFailure")
    WRAPPER_UNRECOVERABLE_FAILURE("wrapperUnrecoverableFailure", "825"),

    @JsonProperty("wrapperUnrecoverableStorageError")
    WRAPPER_UNRECOVERABLE_STORAGE_ERROR("wrapperUnrecoverableStorageError", "826"),

    @JsonProperty("wrapperWarmingUp")
    WRAPPER_WARMING_UP("wrapperWarmingUp", "827");

    private final String name;
    private final String value;

    private PrinterProcessingStateDetail(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
