package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PrintScaling implements Enum {

    @JsonProperty("auto")
    AUTO("auto", "0"),

    @JsonProperty("shrinkToFit")
    SHRINK_TO_FIT("shrinkToFit", "1"),

    @JsonProperty("fill")
    FILL("fill", "2"),

    @JsonProperty("fit")
    FIT("fit", "3"),

    @JsonProperty("none")
    NONE("none", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private PrintScaling(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
