package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PrintOrientation implements Enum {

    @JsonProperty("portrait")
    PORTRAIT("portrait", "3"),

    @JsonProperty("landscape")
    LANDSCAPE("landscape", "4"),

    @JsonProperty("reverseLandscape")
    REVERSE_LANDSCAPE("reverseLandscape", "5"),

    @JsonProperty("reversePortrait")
    REVERSE_PORTRAIT("reversePortrait", "6");

    private final String name;
    private final String value;

    private PrintOrientation(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
