package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PrintMultipageLayout implements Enum {

    @JsonProperty("clockwiseFromTopLeft")
    CLOCKWISE_FROM_TOP_LEFT("clockwiseFromTopLeft", "0"),

    @JsonProperty("counterclockwiseFromTopLeft")
    COUNTERCLOCKWISE_FROM_TOP_LEFT("counterclockwiseFromTopLeft", "1"),

    @JsonProperty("counterclockwiseFromTopRight")
    COUNTERCLOCKWISE_FROM_TOP_RIGHT("counterclockwiseFromTopRight", "2"),

    @JsonProperty("clockwiseFromTopRight")
    CLOCKWISE_FROM_TOP_RIGHT("clockwiseFromTopRight", "3"),

    @JsonProperty("counterclockwiseFromBottomLeft")
    COUNTERCLOCKWISE_FROM_BOTTOM_LEFT("counterclockwiseFromBottomLeft", "4"),

    @JsonProperty("clockwiseFromBottomLeft")
    CLOCKWISE_FROM_BOTTOM_LEFT("clockwiseFromBottomLeft", "5"),

    @JsonProperty("counterclockwiseFromBottomRight")
    COUNTERCLOCKWISE_FROM_BOTTOM_RIGHT("counterclockwiseFromBottomRight", "6"),

    @JsonProperty("clockwiseFromBottomRight")
    CLOCKWISE_FROM_BOTTOM_RIGHT("clockwiseFromBottomRight", "7");

    private final String name;
    private final String value;

    private PrintMultipageLayout(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
