package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PrintJobStateDetail implements Enum {

    @JsonProperty("uploadPending")
    UPLOAD_PENDING("uploadPending", "0"),

    @JsonProperty("transforming")
    TRANSFORMING("transforming", "1"),

    @JsonProperty("completedSuccessfully")
    COMPLETED_SUCCESSFULLY("completedSuccessfully", "2"),

    @JsonProperty("completedWithWarnings")
    COMPLETED_WITH_WARNINGS("completedWithWarnings", "3"),

    @JsonProperty("completedWithErrors")
    COMPLETED_WITH_ERRORS("completedWithErrors", "4"),

    @JsonProperty("releaseWait")
    RELEASE_WAIT("releaseWait", "5"),

    @JsonProperty("interpreting")
    INTERPRETING("interpreting", "6"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "7");

    private final String name;
    private final String value;

    private PrintJobStateDetail(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
