package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PolicySetStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("validating")
    VALIDATING("validating", "1"),

    @JsonProperty("partialSuccess")
    PARTIAL_SUCCESS("partialSuccess", "2"),

    @JsonProperty("success")
    SUCCESS("success", "3"),

    @JsonProperty("error")
    ERROR("error", "4"),

    @JsonProperty("notAssigned")
    NOT_ASSIGNED("notAssigned", "5");

    private final String name;
    private final String value;

    private PolicySetStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
