package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PersonalProfilePersonalPlayStoreMode implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("blockedApps")
    BLOCKED_APPS("blockedApps", "1"),

    @JsonProperty("allowedApps")
    ALLOWED_APPS("allowedApps", "2");

    private final String name;
    private final String value;

    private PersonalProfilePersonalPlayStoreMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
