package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PersonAnnualEventType implements Enum {

    @JsonProperty("birthday")
    BIRTHDAY("birthday", "0"),

    @JsonProperty("wedding")
    WEDDING("wedding", "1"),

    @JsonProperty("work")
    WORK("work", "2"),

    @JsonProperty("other")
    OTHER("other", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private PersonAnnualEventType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
