package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PersistentBrowserSessionMode implements Enum {

    @JsonProperty("always")
    ALWAYS("always", "0"),

    @JsonProperty("never")
    NEVER("never", "1");

    private final String name;
    private final String value;

    private PersistentBrowserSessionMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
