package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OverrideOption implements Enum {

    @JsonProperty("notAllowed")
    NOT_ALLOWED("notAllowed", "0"),

    @JsonProperty("allowFalsePositiveOverride")
    ALLOW_FALSE_POSITIVE_OVERRIDE("allowFalsePositiveOverride", "1"),

    @JsonProperty("allowWithJustification")
    ALLOW_WITH_JUSTIFICATION("allowWithJustification", "2"),

    @JsonProperty("allowWithoutJustification")
    ALLOW_WITHOUT_JUSTIFICATION("allowWithoutJustification", "4");

    private final String name;
    private final String value;

    private OverrideOption(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
