package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OperationStatus implements Enum {

    @JsonProperty("NotStarted")
    NOT_STARTED("NotStarted", "0"),

    @JsonProperty("Running")
    RUNNING("Running", "1"),

    @JsonProperty("Completed")
    COMPLETED("Completed", "2"),

    @JsonProperty("Failed")
    FAILED("Failed", "3");

    private final String name;
    private final String value;

    private OperationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
