package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OnlineMeetingRole implements Enum {

    @JsonProperty("attendee")
    ATTENDEE("attendee", "0"),

    @JsonProperty("presenter")
    PRESENTER("presenter", "1"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3"),

    @JsonProperty("producer")
    PRODUCER("producer", "2");

    private final String name;
    private final String value;

    private OnlineMeetingRole(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
