package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OnlineMeetingProviderType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("skypeForBusiness")
    SKYPE_FOR_BUSINESS("skypeForBusiness", "1"),

    @JsonProperty("skypeForConsumer")
    SKYPE_FOR_CONSUMER("skypeForConsumer", "2"),

    @JsonProperty("teamsForBusiness")
    TEAMS_FOR_BUSINESS("teamsForBusiness", "3");

    private final String name;
    private final String value;

    private OnlineMeetingProviderType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
