package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OnlineMeetingPresenters implements Enum {

    @JsonProperty("everyone")
    EVERYONE("everyone", "0"),

    @JsonProperty("organization")
    ORGANIZATION("organization", "1"),

    @JsonProperty("roleIsPresenter")
    ROLE_IS_PRESENTER("roleIsPresenter", "2"),

    @JsonProperty("organizer")
    ORGANIZER("organizer", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private OnlineMeetingPresenters(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
