package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OnenoteUserRole implements Enum {

    @JsonProperty("None")
    NONE("None", "-1"),

    @JsonProperty("Owner")
    OWNER("Owner", "0"),

    @JsonProperty("Contributor")
    CONTRIBUTOR("Contributor", "1"),

    @JsonProperty("Reader")
    READER("Reader", "2");

    private final String name;
    private final String value;

    private OnenoteUserRole(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
