package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum OnenotePatchActionType implements Enum {

    @JsonProperty("Replace")
    REPLACE("Replace", "0"),

    @JsonProperty("Append")
    APPEND("Append", "1"),

    @JsonProperty("Delete")
    DELETE("Delete", "2"),

    @JsonProperty("Insert")
    INSERT("Insert", "3"),

    @JsonProperty("Prepend")
    PREPEND("Prepend", "4");

    private final String name;
    private final String value;

    private OnenotePatchActionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
