package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MigrationStatus implements Enum {

    @JsonProperty("ready")
    READY("ready", "0"),

    @JsonProperty("needsReview")
    NEEDS_REVIEW("needsReview", "1"),

    @JsonProperty("additionalStepsRequired")
    ADDITIONAL_STEPS_REQUIRED("additionalStepsRequired", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private MigrationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
