package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MicrosoftTunnelServerHealthStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("healthy")
    HEALTHY("healthy", "1"),

    @JsonProperty("unhealthy")
    UNHEALTHY("unhealthy", "2"),

    @JsonProperty("warning")
    WARNING("warning", "3"),

    @JsonProperty("offline")
    OFFLINE("offline", "4"),

    @JsonProperty("upgradeInProgress")
    UPGRADE_IN_PROGRESS("upgradeInProgress", "5"),

    @JsonProperty("upgradeFailed")
    UPGRADE_FAILED("upgradeFailed", "6");

    private final String name;
    private final String value;

    private MicrosoftTunnelServerHealthStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
