package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MicrosoftManagedDesktopType implements Enum {

    @JsonProperty("notManaged")
    NOT_MANAGED("notManaged", "0"),

    @JsonProperty("premiumManaged")
    PREMIUM_MANAGED("premiumManaged", "1"),

    @JsonProperty("standardManaged")
    STANDARD_MANAGED("standardManaged", "2"),

    @JsonProperty("starterManaged")
    STARTER_MANAGED("starterManaged", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "999");

    private final String name;
    private final String value;

    private MicrosoftManagedDesktopType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
