package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MicrosoftLauncherSearchBarPlacement implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("top")
    TOP("top", "1"),

    @JsonProperty("bottom")
    BOTTOM("bottom", "2"),

    @JsonProperty("hide")
    HIDE("hide", "3");

    private final String name;
    private final String value;

    private MicrosoftLauncherSearchBarPlacement(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
