package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MicrosoftEdgeChannel implements Enum {

    @JsonProperty("dev")
    DEV("dev", "0"),

    @JsonProperty("beta")
    BETA("beta", "1"),

    @JsonProperty("stable")
    STABLE("stable", "2");

    private final String name;
    private final String value;

    private MicrosoftEdgeChannel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
