package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MicrosoftAuthenticatorAuthenticationMode implements Enum {

    @JsonProperty("deviceBasedPush")
    DEVICE_BASED_PUSH("deviceBasedPush", "0"),

    @JsonProperty("push")
    PUSH("push", "1"),

    @JsonProperty("any")
    ANY("any", "2");

    private final String name;
    private final String value;

    private MicrosoftAuthenticatorAuthenticationMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
