package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MessageStatus implements Enum {

    @JsonProperty("gettingStatus")
    GETTING_STATUS("gettingStatus", "1"),

    @JsonProperty("pending")
    PENDING("pending", "2"),

    @JsonProperty("failed")
    FAILED("failed", "3"),

    @JsonProperty("delivered")
    DELIVERED("delivered", "4"),

    @JsonProperty("expanded")
    EXPANDED("expanded", "5"),

    @JsonProperty("quarantined")
    QUARANTINED("quarantined", "6"),

    @JsonProperty("filteredAsSpam")
    FILTERED_AS_SPAM("filteredAsSpam", "7"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "8");

    private final String name;
    private final String value;

    private MessageStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
