package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MembershipRuleProcessingStatusDetails implements Enum {

    @JsonProperty("NotStarted")
    NOT_STARTED("NotStarted", "0"),

    @JsonProperty("Running")
    RUNNING("Running", "1"),

    @JsonProperty("Failed")
    FAILED("Failed", "2"),

    @JsonProperty("Succeeded")
    SUCCEEDED("Succeeded", "3"),

    @JsonProperty("UnsupportedFutureValue")
    UNSUPPORTED_FUTURE_VALUE("UnsupportedFutureValue", "4");

    private final String name;
    private final String value;

    private MembershipRuleProcessingStatusDetails(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
