package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MediaSourceContentCategory implements Enum {

    @JsonProperty("meeting")
    MEETING("meeting", "0"),

    @JsonProperty("liveStream")
    LIVE_STREAM("liveStream", "1"),

    @JsonProperty("presentation")
    PRESENTATION("presentation", "2"),

    @JsonProperty("screenRecording")
    SCREEN_RECORDING("screenRecording", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private MediaSourceContentCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
