package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MdmSupportedState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("supported")
    SUPPORTED("supported", "1"),

    @JsonProperty("unsupported")
    UNSUPPORTED("unsupported", "2"),

    @JsonProperty("deprecated")
    DEPRECATED("deprecated", "3");

    private final String name;
    private final String value;

    private MdmSupportedState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
