package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagedDevicePartnerReportedHealthState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("activated")
    ACTIVATED("activated", "1"),

    @JsonProperty("deactivated")
    DEACTIVATED("deactivated", "2"),

    @JsonProperty("secured")
    SECURED("secured", "3"),

    @JsonProperty("lowSeverity")
    LOW_SEVERITY("lowSeverity", "4"),

    @JsonProperty("mediumSeverity")
    MEDIUM_SEVERITY("mediumSeverity", "5"),

    @JsonProperty("highSeverity")
    HIGH_SEVERITY("highSeverity", "6"),

    @JsonProperty("unresponsive")
    UNRESPONSIVE("unresponsive", "7"),

    @JsonProperty("compromised")
    COMPROMISED("compromised", "8"),

    @JsonProperty("misconfigured")
    MISCONFIGURED("misconfigured", "9");

    private final String name;
    private final String value;

    private ManagedDevicePartnerReportedHealthState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
