package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagedAppPinCharacterSet implements Enum {

    @JsonProperty("numeric")
    NUMERIC("numeric", "0"),

    @JsonProperty("alphanumericAndSymbol")
    ALPHANUMERIC_AND_SYMBOL("alphanumericAndSymbol", "1");

    private final String name;
    private final String value;

    private ManagedAppPinCharacterSet(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
