package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagedAppDeviceThreatLevel implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("secured")
    SECURED("secured", "1"),

    @JsonProperty("low")
    LOW("low", "2"),

    @JsonProperty("medium")
    MEDIUM("medium", "3"),

    @JsonProperty("high")
    HIGH("high", "4");

    private final String name;
    private final String value;

    private ManagedAppDeviceThreatLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
