package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MailTipsType implements Enum {

    @JsonProperty("automaticReplies")
    AUTOMATIC_REPLIES("automaticReplies", "1"),

    @JsonProperty("mailboxFullStatus")
    MAILBOX_FULL_STATUS("mailboxFullStatus", "2"),

    @JsonProperty("customMailTip")
    CUSTOM_MAIL_TIP("customMailTip", "4"),

    @JsonProperty("externalMemberCount")
    EXTERNAL_MEMBER_COUNT("externalMemberCount", "8"),

    @JsonProperty("totalMemberCount")
    TOTAL_MEMBER_COUNT("totalMemberCount", "16"),

    @JsonProperty("maxMessageSize")
    MAX_MESSAGE_SIZE("maxMessageSize", "32"),

    @JsonProperty("deliveryRestriction")
    DELIVERY_RESTRICTION("deliveryRestriction", "64"),

    @JsonProperty("moderationStatus")
    MODERATION_STATUS("moderationStatus", "128"),

    @JsonProperty("recipientScope")
    RECIPIENT_SCOPE("recipientScope", "256"),

    @JsonProperty("recipientSuggestions")
    RECIPIENT_SUGGESTIONS("recipientSuggestions", "512");

    private final String name;
    private final String value;

    private MailTipsType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
