package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MailDestinationRoutingReason implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("mailFlowRule")
    MAIL_FLOW_RULE("mailFlowRule", "1"),

    @JsonProperty("safeSender")
    SAFE_SENDER("safeSender", "2"),

    @JsonProperty("blockedSender")
    BLOCKED_SENDER("blockedSender", "3"),

    @JsonProperty("advancedSpamFiltering")
    ADVANCED_SPAM_FILTERING("advancedSpamFiltering", "4"),

    @JsonProperty("domainAllowList")
    DOMAIN_ALLOW_LIST("domainAllowList", "5"),

    @JsonProperty("domainBlockList")
    DOMAIN_BLOCK_LIST("domainBlockList", "6"),

    @JsonProperty("notInAddressBook")
    NOT_IN_ADDRESS_BOOK("notInAddressBook", "7"),

    @JsonProperty("firstTimeSender")
    FIRST_TIME_SENDER("firstTimeSender", "8"),

    @JsonProperty("autoPurgeToInbox")
    AUTO_PURGE_TO_INBOX("autoPurgeToInbox", "9"),

    @JsonProperty("autoPurgeToJunk")
    AUTO_PURGE_TO_JUNK("autoPurgeToJunk", "10"),

    @JsonProperty("autoPurgeToDeleted")
    AUTO_PURGE_TO_DELETED("autoPurgeToDeleted", "11"),

    @JsonProperty("outbound")
    OUTBOUND("outbound", "12"),

    @JsonProperty("notJunk")
    NOT_JUNK("notJunk", "13"),

    @JsonProperty("junk")
    JUNK("junk", "14"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "15");

    private final String name;
    private final String value;

    private MailDestinationRoutingReason(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
